/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.core.util.validators;

import com.jaspersoft.jasperserver.core.util.validators.RegExpValidator;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EmailInputValidator<T>
extends RegExpValidator<T> {
    private static final Log log = LogFactory.getLog(EmailInputValidator.class);

    @Override
    public boolean isValid(T email) {
        boolean result;
        block4: {
            if (email == null) {
                return false;
            }
            if (this.getPattern() != null) {
                return super.isValid(email);
            }
            result = true;
            try {
                InternetAddress emailAddress = new InternetAddress(email.toString());
                emailAddress.validate();
            }
            catch (AddressException ex) {
                result = false;
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)String.format("Email address %s not valid.", email));
            }
        }
        return result;
    }
}

