/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.tempdata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.teiid.language.Like;
import org.teiid.language.SortSpecification;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.processor.relational.ListNestedSortComparator;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.MatchCriteria;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.tempdata.SearchableTable;

public class BaseIndexInfo<T extends SearchableTable> {
    List<Object> lower = null;
    List<Object> upper = null;
    ArrayList<List<Object>> valueSet = new ArrayList();
    T table;
    Boolean ordering;
    boolean covering;
    CompoundCriteria nonCoveredCriteria = null;
    CompoundCriteria coveredCriteria = null;
    public BaseIndexInfo<?> next;

    public BaseIndexInfo(T table, List<? extends Expression> projectedCols, Criteria condition, OrderBy orderBy, boolean primary) {
        this.table = table;
        if (primary || this.table.getColumnMap().keySet().containsAll(projectedCols)) {
            this.covering = true;
        }
        if (table.getPkLength() > 0) {
            this.processCriteria(condition, primary);
            if (orderBy != null) {
                this.ordering = this.useIndexForOrderBy(orderBy);
            }
        }
    }

    private void processCriteria(Criteria condition, boolean primary) {
        List<Criteria> crits = Criteria.separateCriteriaByAnd(condition);
        if (!primary) {
            Iterator<Criteria> critIter = crits.iterator();
            while (critIter.hasNext()) {
                Criteria criteria = critIter.next();
                if (this.table.getColumnMap().keySet().containsAll(ElementCollectorVisitor.getElements((LanguageObject)criteria, false))) {
                    if (this.coveredCriteria == null) {
                        this.coveredCriteria = new CompoundCriteria();
                    }
                    this.coveredCriteria.addCriteria(criteria);
                    continue;
                }
                this.covering = false;
                if (this.nonCoveredCriteria == null) {
                    this.nonCoveredCriteria = new CompoundCriteria();
                }
                this.nonCoveredCriteria.addCriteria(criteria);
                critIter.remove();
            }
        }
        for (int i = 0; i < this.table.getPkLength(); ++i) {
            Iterator<Criteria> critIter = crits.iterator();
            while (critIter.hasNext()) {
                SetCriteria setCriteria;
                Criteria criteria = critIter.next();
                if (criteria instanceof CompareCriteria) {
                    CompareCriteria cc = (CompareCriteria)criteria;
                    if (!this.table.matchesPkColumn(i, cc.getLeftExpression())) continue;
                    if (!this.table.supportsOrdering(i, cc.getLeftExpression()) && cc.getOperator() != 1) {
                        critIter.remove();
                        continue;
                    }
                    this.addCondition(i, (Constant)cc.getRightExpression(), cc.getOperator());
                    critIter.remove();
                    continue;
                }
                if (criteria instanceof IsNullCriteria) {
                    IsNullCriteria inc = (IsNullCriteria)criteria;
                    if (!this.table.matchesPkColumn(i, inc.getExpression())) continue;
                    this.addCondition(i, new Constant(null), 1);
                    critIter.remove();
                    continue;
                }
                if (criteria instanceof MatchCriteria) {
                    int j;
                    MatchCriteria matchCriteria = (MatchCriteria)criteria;
                    if (!this.table.matchesPkColumn(i, matchCriteria.getLeftExpression())) continue;
                    Constant value = (Constant)matchCriteria.getRightExpression();
                    String pattern = (String)value.getValue();
                    boolean escaped = false;
                    char escapeChar = matchCriteria.getEscapeChar();
                    if (matchCriteria.getMode() == Like.MatchMode.REGEX) {
                        escapeChar = '\\';
                    }
                    StringBuilder prefix = new StringBuilder();
                    if (pattern.length() > 0 && matchCriteria.getMode() == Like.MatchMode.REGEX && pattern.charAt(0) != '^') continue;
                    int n = j = matchCriteria.getMode() == Like.MatchMode.REGEX ? 1 : 0;
                    while (j < pattern.length()) {
                        char character = pattern.charAt(j);
                        if (character == escapeChar && character != '\u0000') {
                            if (escaped) {
                                prefix.append(character);
                                escaped = false;
                            } else {
                                escaped = true;
                            }
                        } else {
                            if (!escaped) {
                                if (matchCriteria.getMode() == Like.MatchMode.LIKE) {
                                    if (character == '%' || character == '_') {
                                        break;
                                    }
                                } else {
                                    int index = Arrays.binarySearch(Evaluator.REGEX_RESERVED, character);
                                    if (index >= 0 && pattern.length() > 0) {
                                        this.getRegexPrefix(pattern, escapeChar, prefix, j, character);
                                        break;
                                    }
                                }
                            } else {
                                escaped = false;
                            }
                            prefix.append(character);
                        }
                        ++j;
                    }
                    if (prefix.length() > 0) {
                        this.addCondition(i, new Constant(prefix.toString()), 6);
                        this.addCondition(i, new Constant(prefix.substring(0, prefix.length() - 1) + (char)(prefix.charAt(prefix.length() - 1) + '\u0001')), 5);
                        continue;
                    }
                    critIter.remove();
                    continue;
                }
                if (!(criteria instanceof SetCriteria) || !this.table.matchesPkColumn(i, (setCriteria = (SetCriteria)criteria).getExpression())) continue;
                Collection values = setCriteria.getValues();
                this.addSet(i, values);
                critIter.remove();
            }
        }
    }

    private void getRegexPrefix(String pattern, char escapeChar, StringBuilder prefix, int j, char character) {
        boolean escaped = false;
        int level = 0;
        for (int k = j; k < pattern.length(); ++k) {
            character = pattern.charAt(k);
            if (character == escapeChar && character != '\u0000') {
                escaped = !escaped;
                continue;
            }
            if (escaped) continue;
            if (character == '(') {
                ++level;
                continue;
            }
            if (character == ')') {
                --level;
                continue;
            }
            if (character != '|' || level != 0) continue;
            prefix.setLength(0);
            return;
        }
        if (character == '{' || character == '?' || character == '*') {
            prefix.setLength(prefix.length() - 1);
        }
    }

    void addCondition(int i, Constant value, int comparisionMode) {
        Object value2 = value.getValue();
        switch (comparisionMode) {
            case 1: {
                if (i == 0) {
                    this.valueSet.clear();
                    this.valueSet.add(new ArrayList(this.table.getPkLength()));
                }
                if (this.valueSet.size() == 1) {
                    this.valueSet.get(0).add(value2);
                }
                this.lower = null;
                this.upper = null;
                break;
            }
            case 4: 
            case 6: {
                if (!this.valueSet.isEmpty()) break;
                if (i == 0) {
                    this.lower = new ArrayList<Object>(this.table.getPkLength());
                    this.lower.add(value2);
                }
                if (this.lower == null || this.lower.size() != i) break;
                this.lower.add(value2);
                break;
            }
            case 3: 
            case 5: {
                if (!this.valueSet.isEmpty()) break;
                if (i == 0) {
                    this.upper = new ArrayList<Object>(this.table.getPkLength());
                    this.upper.add(value2);
                    break;
                }
                if (this.upper == null || this.upper.size() != i) break;
                this.upper.add(value2);
            }
        }
    }

    void addSet(int i, Collection<Constant> values) {
        if (!this.valueSet.isEmpty()) {
            return;
        }
        if (i == 0) {
            for (Constant constant : values) {
                ArrayList<Object> value = new ArrayList<Object>(this.table.getPkLength());
                Object value2 = constant.getValue();
                value.add(value2);
                this.valueSet.add(value);
            }
            this.lower = null;
            this.upper = null;
        }
    }

    private Boolean useIndexForOrderBy(OrderBy orderBy) {
        Boolean direction = null;
        int size = orderBy.getOrderByItems().size();
        if (size > this.table.getPkLength()) {
            return null;
        }
        for (int i = 0; i < size; ++i) {
            OrderByItem item = orderBy.getOrderByItems().get(i);
            if (!this.table.matchesPkColumn(i, item.getSymbol()) || !this.table.supportsOrdering(i, item.getSymbol())) {
                return null;
            }
            if (item.getNullOrdering() != null && (item.isAscending() && item.getNullOrdering() == SortSpecification.NullOrdering.LAST || !item.isAscending() && item.getNullOrdering() == SortSpecification.NullOrdering.FIRST)) {
                return null;
            }
            if (item.isAscending()) {
                if (direction == null) {
                    direction = true;
                    continue;
                }
                if (direction.booleanValue()) continue;
                return null;
            }
            if (direction == null) {
                direction = false;
                continue;
            }
            if (!direction.booleanValue()) continue;
            return null;
        }
        return direction;
    }

    public List<Object> getLower() {
        return this.lower;
    }

    public List<Object> getUpper() {
        return this.upper;
    }

    public ArrayList<List<Object>> getValueSet() {
        return this.valueSet;
    }

    public void sortValueSet(boolean direction) {
        int size = this.getValueSet().get(0).size();
        int[] sortOn = new int[size];
        for (int i = 0; i < sortOn.length; ++i) {
            sortOn[i] = i;
        }
        Collections.sort(this.getValueSet(), new ListNestedSortComparator(sortOn, direction));
    }

    public Criteria getCoveredCriteria() {
        return this.coveredCriteria;
    }

    public Criteria getNonCoveredCriteria() {
        return this.nonCoveredCriteria;
    }
}

