/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Tenant;
import com.jaspersoft.jasperserver.api.metadata.user.domain.TenantQualified;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;
import com.jaspersoft.jasperserver.war.action.BaseFormAction;
import com.jaspersoft.jasperserver.war.action.EntitiesListState;
import com.jaspersoft.jasperserver.war.common.ConfigurationBean;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public abstract class BaseManagerAction
extends BaseFormAction {
    protected static final String FLOW_ATTRIBUTE_STATE = "state";
    protected static final String FLOW_ATTRIBUTE_CURRENT_USER = "signedUser";
    protected static final String FLOW_ATTRIBUTE_CURRENT_USER_ROLES = "currentUserRoles";
    protected static final String FLOW_ATTRIBUTE_DEFAULT_ENTITY = "defaultEntity";
    protected static final String FLOW_ATTRIBUTE_CONFIGURATION = "configuration";
    protected static final String PARAMETER_TENANT_ID = "tenantId";
    protected static final String PARAMETER_TEXT = "text";
    protected static final String PARAMETER_ENTITY = "entity";
    protected static final String PARAMETER_ENTITY_NAME = "entityName";
    protected static final String PARAMETER_ENTITIES = "entities";
    protected static final String PARAMETER_ASSIGNED_ENTITIES = "assignedEntities";
    protected static final String PARAMETER_UNASSIGNED_ENTITIES = "unassignedEntities";
    protected static final String JSON_ATTRIBUTE_SUPERUSER_ROLE = "superuserRole";
    protected static final String JSON_ATTRIBUTE_ADMIN_ROLE = "adminRole";
    protected static final String JSON_TENANT_URI = "tenantUri";
    protected static final String ROLE_SUPERUSER = "ROLE_SUPERUSER";
    protected static final String ROLE_ADMINISTRATOR = "ROLE_ADMINISTRATOR";
    protected ConfigurationBean configuration;
    protected UserAuthorityService userService;

    public void setConfiguration(ConfigurationBean configurationBean) {
        this.configuration = configurationBean;
    }

    public Map getSession(RequestContext context) {
        return context.getExternalContext().getSessionMap().asMap();
    }

    public void setUserService(UserAuthorityService userService) {
        this.userService = userService;
    }

    protected void initState(RequestContext context) throws JSONException {
        String tenantId;
        State state = new State();
        this.putState(context, state);
        String text = this.getDecodedRequestParameter(context, PARAMETER_TEXT);
        if (text != null && text.length() > 0) {
            state.getEntitiesState().updateText(text);
        }
        if ((tenantId = this.getDecodedRequestParameter(context, PARAMETER_TENANT_ID)) != null && tenantId.length() > 0) {
            state.updateTenantId(tenantId);
        } else {
            state.updateTenantId(this.getCurrentTenantId());
        }
        context.getFlashScope().put(FLOW_ATTRIBUTE_STATE, (Object)this.createExtendedStateJson(context));
    }

    private JSONObject createExtendedStateJson(RequestContext context) throws JSONException {
        State state = this.getState(context);
        JSONObject jsonObject = state.toJson();
        Tenant tenant = this.tenantService.getTenant(this.exContext(context), state.getTenantId() == null ? "organizations" : state.getTenantId());
        jsonObject.put(JSON_TENANT_URI, (Object)tenant.getTenantUri());
        return jsonObject;
    }

    @Override
    protected State getState(RequestContext context) {
        return (State)super.getState(context);
    }

    public Event browse(RequestContext context) {
        String tenantId = this.getParameter(context, PARAMETER_TENANT_ID);
        this.getState(context).updateTenantId(tenantId != null && tenantId.length() > 0 ? tenantId : null);
        return this.success();
    }

    public Event search(RequestContext context) {
        this.getState(context).getEntitiesState().updateText(this.getParameter(context, PARAMETER_TEXT));
        return this.success();
    }

    public abstract Event next(RequestContext var1);

    public Event select(RequestContext context) {
        this.getState(context).updateSelectedEntity(this.getParameter(context, PARAMETER_ENTITY));
        return this.success();
    }

    public abstract Event getDetails(RequestContext var1);

    public Event searchAvailable(RequestContext context) {
        State state = this.getState(context);
        String text = this.getParameter(context, PARAMETER_TEXT);
        state.getAvailableEntitiesState().updateText(text);
        return this.success();
    }

    public Event searchAssigned(RequestContext context) {
        State state = this.getState(context);
        String text = this.getParameter(context, PARAMETER_TEXT);
        state.getAssignedEntitiesState().updateText(text);
        return this.success();
    }

    public abstract Event nextAssigned(RequestContext var1);

    public abstract Event nextAvailable(RequestContext var1);

    public abstract Event exist(RequestContext var1);

    public abstract Event delete(RequestContext var1);

    public abstract Event deleteAll(RequestContext var1);

    public abstract Event create(RequestContext var1);

    protected List<String> getEntities(RequestContext context) throws JSONException {
        ArrayList<String> entities = new ArrayList<String>();
        String json = context.getRequestParameters().get(PARAMETER_ENTITIES);
        if (json != null) {
            JSONArray array = new JSONArray(json);
            for (int i = 0; i < array.length(); ++i) {
                entities.add(array.getString(i));
            }
        }
        return entities;
    }

    protected String getDefaultEntity(RequestContext context) {
        State state = this.getState(context);
        String name = state.getEntitiesState().getText();
        String tId = state.getTenantId();
        StringBuilder qName = new StringBuilder();
        if (name != null) {
            qName.append(name);
        }
        if (tId != null) {
            qName.append(this.configuration.getUserNameSeparator());
            qName.append(tId);
        }
        return qName.toString();
    }

    protected String getCurrentUser() {
        Authentication authenticationToken = SecurityContextHolder.getContext().getAuthentication();
        String name = authenticationToken.getName();
        TenantQualified tenantQualified = (TenantQualified)authenticationToken.getPrincipal();
        if (authenticationToken.getPrincipal() instanceof TenantQualified) {
            String tenantId = tenantQualified.getTenantId();
            return tenantId != null ? name + this.configuration.getUserNameSeparator() + tenantId : name;
        }
        return name;
    }

    protected String createUnexpectedExceptionResponseModel(Exception unexpectedException) throws JSONException {
        return this.createUnexpectedExceptionResponseModel(unexpectedException.getMessage());
    }

    protected String createUnexpectedExceptionResponseModel(String description) throws JSONException {
        String message = this.messages.getMessage("jsp.userManager.unexpectedException", new Object[0], LocaleContextHolder.getLocale());
        JSONObject exceptionJson = this.jsonHelper.createUnexpectedExceptionJson("", message, description);
        return this.jsonHelper.createErrorResponseModel(exceptionJson);
    }

    protected ExecutionContext exContext(RequestContext context) {
        return JasperServerUtil.getExecutionContext(context);
    }

    public class State
    implements Serializable {
        private static final String TEXT = "text";
        private static final String TENANT_ID = "tenantId";
        private static final String SELECTED_ENTITY = "selectedEntity";
        private static final String AVAILABLE_TEXT = "availableText";
        private static final String ASSIGNED_TEXT = "assignedText";
        private String tenantId;
        private EntitiesListState entitiesState = new EntitiesListState();
        private String selectedEntity;
        private EntitiesListState availableEntitiesState = new EntitiesListState();
        private EntitiesListState assignedEntitiesState = new EntitiesListState();

        public String getTenantId() {
            return this.tenantId;
        }

        public void updateTenantId(String tenantId) {
            this.tenantId = tenantId;
            this.entitiesState.updateResultState(0, 0);
        }

        public EntitiesListState getEntitiesState() {
            return this.entitiesState;
        }

        public String getSelectedEntity() {
            return this.selectedEntity;
        }

        public void updateSelectedEntity(String selectedEntity) {
            this.selectedEntity = selectedEntity;
            this.availableEntitiesState.updateResultState(0, 0);
            this.assignedEntitiesState.updateResultState(0, 0);
        }

        public EntitiesListState getAvailableEntitiesState() {
            return this.availableEntitiesState;
        }

        public EntitiesListState getAssignedEntitiesState() {
            return this.assignedEntitiesState;
        }

        public JSONObject toJson() throws JSONException {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("text", (Object)this.entitiesState.getText());
            jsonObject.put("tenantId", (Object)this.tenantId);
            jsonObject.put(SELECTED_ENTITY, (Object)this.selectedEntity);
            jsonObject.put(AVAILABLE_TEXT, (Object)this.availableEntitiesState.getText());
            jsonObject.put(ASSIGNED_TEXT, (Object)this.assignedEntitiesState.getText());
            return jsonObject;
        }
    }
}

