/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.common.properties.PropertiesManagementService;
import com.jaspersoft.jasperserver.api.logging.audit.context.AuditContext;
import com.jaspersoft.jasperserver.api.logging.audit.domain.AuditEvent;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.webflow.action.MultiAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class EditMondrianPropertiesAction
extends MultiAction {
    private static final Log log = LogFactory.getLog(EditMondrianPropertiesAction.class);
    private static final String OPTION_NAME = "name";
    private static final String OPTION_VALUE = "value";
    protected PropertiesManagementService propertiesManagementService;
    private RepositoryService repository;
    private AuditContext auditContext;

    private void createAuditEvent() {
        this.auditContext.doInAuditContext(new AuditContext.AuditContextCallback(){

            public void execute() {
                EditMondrianPropertiesAction.this.auditContext.createAuditEvent("updateAnalysisOptions");
            }
        });
    }

    private void addParamToAuditEvent(final Object param) {
        this.auditContext.doInAuditContext("updateAnalysisOptions", new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                EditMondrianPropertiesAction.this.auditContext.addPropertyToAuditEvent("analysisOption", param, auditEvent);
            }
        });
    }

    private void closeAuditEvent() {
        this.auditContext.doInAuditContext("updateAnalysisOptions", new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                EditMondrianPropertiesAction.this.auditContext.closeAuditEvent(auditEvent);
            }
        });
    }

    public Event saveSingleProperty(RequestContext context) throws Exception {
        log.info((Object)"Saving OLAP Server Property");
        String key = context.getRequestParameters().get(OPTION_NAME);
        String value = context.getRequestParameters().get(OPTION_VALUE);
        String res = "";
        String error = this.validate(key, value);
        if (error == null) {
            this.createAuditEvent();
            this.saveSingleProperty(key, value);
            this.addParamToAuditEvent(new Object[]{key, value});
            this.closeAuditEvent();
            res = "{\"result\":\"JAM_056_UPDATED\",\"optionName\":\"" + key + "\"}";
        } else {
            res = "{\"error\":\"" + error + "\",\"optionName\":\"" + key + "\"}";
        }
        context.getRequestScope().put("ajaxResponseModel", (Object)res);
        return this.success();
    }

    protected void saveSingleProperty(String key, String value) {
        this.getPropertiesManagementService().setProperty(key, value);
    }

    private String validate(String option, String value) {
        block19: {
            if (option.equals("mondrian.query.limit") || option.equals("mondrian.rolap.evaluate.MaxEvalDepth") || option.equals("mondrian.result.highCardChunkSize") || option.equals("mondrian.rolap.SparseSegmentValueThreshold") || option.equals("mondrian.rolap.maxConstraints")) {
                try {
                    Integer test = new Integer(value);
                    if (test < 1) {
                        return "JAM_049_ONE_OR_GREATER";
                    }
                    break block19;
                }
                catch (Exception e) {
                    log.debug((Object)(option + " invalid input"));
                    return "JAM_019_WHOLE_NUMBER_ERROR";
                }
            }
            if (option.equals("mondrian.xmla.drillthroughMaxRows") || option.equals("mondrian.result.limit") || option.equals("mondrian.rolap.iterationLimit") || option.equals("mondrian.olap.fun.crossjoin.optimizer.size") || option.equals("mondrian.rolap.queryTimeout")) {
                try {
                    Integer test = new Integer(value);
                    if (test < 0) {
                        return "JAM_048_ZERO_OR_GREATER";
                    }
                    break block19;
                }
                catch (Exception e) {
                    log.debug((Object)(option + " invalid input"));
                    return "JAM_019_WHOLE_NUMBER_ERROR";
                }
            }
            if (option.equals("mondrian.rolap.SparseSegmentDensityThreshold")) {
                try {
                    Double d = new Double(value);
                    if (d > 1.0 || d < 0.0) {
                        log.debug((Object)(option + " invalid input"));
                        return "JAM_020_RATIO_NUMBER_ERROR";
                    }
                    break block19;
                }
                catch (Exception e) {
                    log.debug((Object)(option + " invalid input"));
                    return "JAM_020_RATIO_NUMBER_ERROR";
                }
            }
            if (option.equals("mondrian.util.memoryMonitor.percentage.threshold")) {
                try {
                    Integer test = new Integer(value);
                    if (test < 1 || test > 99) {
                        return "JAM_050_ONE_TO_99";
                    }
                    break block19;
                }
                catch (Exception e) {
                    log.debug((Object)(option + " invalid input"));
                    return "JAM_019_WHOLE_NUMBER_ERROR";
                }
            }
            if ((option.equals("mondrian.rolap.aggregates.jdbcFactoryClass") || option.equals("mondrian.util.MemoryMonitor.class") || option.equals("mondrian.calc.ExpCompiler.class")) && !value.trim().equals("null")) {
                try {
                    Class.forName(value);
                }
                catch (Exception e) {
                    log.debug((Object)(option + " invalid input"));
                    return "JAM_051_INVALID_CLASS";
                }
            }
        }
        return null;
    }

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public AuditContext getAuditContext() {
        return this.auditContext;
    }

    public void setAuditContext(AuditContext auditContext) {
        this.auditContext = auditContext;
    }

    public PropertiesManagementService getPropertiesManagementService() {
        return this.propertiesManagementService;
    }

    public void setPropertiesManagementService(PropertiesManagementService propertiesManagementService) {
        this.propertiesManagementService = propertiesManagementService;
    }
}

