/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Query;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.dto.QueryWrapper;
import com.jaspersoft.jasperserver.war.dto.ResourceReferenceDTO;
import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class QueryReferenceAction
extends FormAction {
    private RepositoryService repository;
    private String queryLookupsRequestAttrName;
    private String queryWrapperRequestAttrName;

    public Event prepareQuerySource(RequestContext context) {
        ResourceLookup[] queryLookups = this.getRepository().findResource(JasperServerUtil.getExecutionContext(context), FilterCriteria.createFilter(Query.class));
        context.getFlowScope().put(this.getQueryLookupsRequestAttrName(), (Object)queryLookups);
        return this.success();
    }

    public Event queryLocal(RequestContext context) throws Exception {
        ResourceReferenceDTO referenceDTO = this.referenceDTO(context);
        Query query = (Query)referenceDTO.getLocalResource();
        if (query == null) {
            query = (Query)this.repository.newResource(null, Query.class);
            query.setLanguage("sql");
            referenceDTO.setLocalResource((Resource)query);
        }
        QueryWrapper queryWrapper = new QueryWrapper(query);
        byte mode = referenceDTO.getLocalResource().isNew() ? (byte)3 : 4;
        queryWrapper.setMode(mode);
        context.getRequestScope().put(this.getQueryWrapperRequestAttrName(), (Object)queryWrapper);
        return this.success();
    }

    protected ResourceReferenceDTO referenceDTO(RequestContext context) throws Exception {
        return (ResourceReferenceDTO)this.getFormObject(context);
    }

    public String getQueryLookupsRequestAttrName() {
        return this.queryLookupsRequestAttrName;
    }

    public void setQueryLookupsRequestAttrName(String referenceURIListRequestAttrName) {
        this.queryLookupsRequestAttrName = referenceURIListRequestAttrName;
    }

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public String getQueryWrapperRequestAttrName() {
        return this.queryWrapperRequestAttrName;
    }

    public void setQueryWrapperRequestAttrName(String queryWrapperRequestAttrName) {
        this.queryWrapperRequestAttrName = queryWrapperRequestAttrName;
    }
}

