/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.jasperreports.common.ExportParameters;
import com.jaspersoft.jasperserver.api.engine.jasperreports.common.TxtExportParametersBean;
import com.jaspersoft.jasperserver.war.action.AbstractReportExporter;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.export.JRTextExporter;
import net.sf.jasperreports.engine.export.JRTextExporterParameter;
import org.springframework.webflow.execution.RequestContext;

public class ReportTextExporter
extends AbstractReportExporter {
    private static final String DIALOG_NAME = "txtExportParams";
    private TxtExportParametersBean exportParameters;

    public TxtExportParametersBean getExportParameters() {
        return this.exportParameters;
    }

    @Override
    public ExportParameters getExportParameters(RequestContext context) {
        return context.getFlowScope().get(DIALOG_NAME) == null ? this.exportParameters : (ExportParameters)context.getFlowScope().get(DIALOG_NAME);
    }

    public void setExportParameters(TxtExportParametersBean exportParameters) {
        this.exportParameters = exportParameters;
    }

    @Override
    public void export(RequestContext context, ExecutionContext executionContext, String reportUnitURI, Map baseParameters) throws JRException, JSException {
        JRTextExporter exporter = new JRTextExporter(this.getJasperReportsContext());
        exporter.setParameters(baseParameters);
        TxtExportParametersBean exportParams = (TxtExportParametersBean)this.getExportParameters(context);
        if (exportParams.isOverrideReportHints()) {
            exporter.setParameter(JRExporterParameter.PARAMETERS_OVERRIDE_REPORT_HINTS, (Object)Boolean.TRUE);
        }
        if (exportParams.getCharacterHeight() != null) {
            exporter.setParameter((JRExporterParameter)JRTextExporterParameter.CHARACTER_HEIGHT, (Object)exportParams.getCharacterHeight());
        }
        if (exportParams.getCharacterWidth() != null) {
            exporter.setParameter((JRExporterParameter)JRTextExporterParameter.CHARACTER_WIDTH, (Object)exportParams.getCharacterWidth());
        }
        if (exportParams.getPageHeight() != null) {
            exporter.setParameter((JRExporterParameter)JRTextExporterParameter.PAGE_HEIGHT, (Object)exportParams.getPageHeight());
        }
        if (exportParams.getPageWidth() != null) {
            exporter.setParameter((JRExporterParameter)JRTextExporterParameter.PAGE_WIDTH, (Object)exportParams.getPageWidth());
        }
        exporter.exportReport();
    }

    @Override
    protected String getContentType(RequestContext context) {
        return "application/txt";
    }

    @Override
    protected void setAdditionalResponseHeaders(RequestContext context, HttpServletResponse response) {
        super.setAdditionalResponseHeaders(context, response);
        response.setHeader("Content-Disposition", "inline; filename=\"" + this.getFilename(context) + "\"");
    }

    @Override
    protected String getDownloadFileExtension() {
        return "txt";
    }
}

