/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.validation;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Query;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.dto.QueryWrapper;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class QueryValidator
implements Validator {
    private RepositoryService repository;

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public boolean supports(Class klass) {
        return QueryWrapper.class.isAssignableFrom(klass);
    }

    public void validate(Object object, Errors errors) {
        QueryWrapper wrapper = (QueryWrapper)object;
        this.validateNameLabelDesc(wrapper, errors);
        this.validateQueryText(wrapper, errors);
    }

    public void validateNameLabelDesc(QueryWrapper wrapper, Errors errors) {
        Query query = wrapper.getQuery();
        if (query.getName() == null || query.getName().trim().length() == 0) {
            errors.rejectValue("query.name", "QueryValidator.error.not.empty");
        } else {
            if (!JasperServerUtil.regExValidateName(query.getName())) {
                errors.rejectValue("query.name", "QueryValidator.error.invalid.chars");
            }
            if (query.getName().length() > 100) {
                errors.rejectValue("query.name", "QueryValidator.error.too.long");
            }
            if (wrapper.isAloneNewMode() && this.repository.repositoryPathExists(null, query.getURIString())) {
                errors.rejectValue("query.name", "QueryValidator.error.duplicate");
            }
        }
        if (query.getLabel() == null || query.getLabel().trim().length() == 0) {
            errors.rejectValue("query.label", "QueryValidator.error.not.empty");
        } else {
            if (!JasperServerUtil.regExValidateLabel(query.getLabel())) {
                errors.rejectValue("query.label", "QueryValidator.error.invalid.chars");
            }
            if (query.getLabel().length() > 100) {
                errors.rejectValue("query.label", "QueryValidator.error.too.long");
            }
        }
        if (query.getDescription() != null && query.getDescription().length() > 250) {
            errors.rejectValue("query.description", "QueryValidator.error.too.long");
        }
    }

    public void validateQueryText(QueryWrapper wrapper, Errors errors) {
        Query query = wrapper.getQuery();
        if (query.getSql() == null || query.getSql().trim().length() == 0) {
            errors.rejectValue("query.sql", "QueryValidator.error.not.empty");
        }
    }
}

