/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.ee.jta;

import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.core.JobRunShell;
import org.quartz.ee.jta.UserTransactionHelper;
import org.quartz.spi.TriggerFiredBundle;

public class JTAJobRunShell
extends JobRunShell {
    private UserTransaction ut;

    public JTAJobRunShell(Scheduler scheduler, TriggerFiredBundle bndle) {
        super(scheduler, bndle);
    }

    protected void begin() throws SchedulerException {
        this.cleanupUserTransaction();
        boolean beganSuccessfully = false;
        try {
            try {
                this.getLog().debug("Looking up UserTransaction.");
                this.ut = UserTransactionHelper.lookupUserTransaction();
                this.getLog().debug("Beginning UserTransaction.");
                this.ut.begin();
                beganSuccessfully = true;
            }
            catch (SchedulerException se) {
                throw se;
            }
            catch (Exception nse) {
                throw new SchedulerException("JTAJobRunShell could not start UserTransaction.", nse);
            }
            Object var4_2 = null;
            if (!beganSuccessfully) {
                this.cleanupUserTransaction();
            }
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (!beganSuccessfully) {
                this.cleanupUserTransaction();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void complete(boolean successfulExecution) throws SchedulerException {
        if (this.ut == null) {
            return;
        }
        try {
            try {
                if (this.ut.getStatus() == 1) {
                    this.getLog().debug("UserTransaction marked for rollback only.");
                    successfulExecution = false;
                }
            }
            catch (SystemException e) {
                throw new SchedulerException("JTAJobRunShell could not read UserTransaction status.", e);
            }
            if (successfulExecution) {
                try {
                    this.getLog().debug("Committing UserTransaction.");
                    this.ut.commit();
                }
                catch (Exception nse) {
                    throw new SchedulerException("JTAJobRunShell could not commit UserTransaction.", nse);
                }
            }
            try {
                this.getLog().debug("Rolling-back UserTransaction.");
                this.ut.rollback();
            }
            catch (Exception nse) {
                throw new SchedulerException("JTAJobRunShell could not rollback UserTransaction.", nse);
            }
            Object var4_5 = null;
            this.cleanupUserTransaction();
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.cleanupUserTransaction();
            throw throwable;
        }
    }

    public void passivate() {
        this.cleanupUserTransaction();
        super.passivate();
    }

    private void cleanupUserTransaction() {
        if (this.ut != null) {
            UserTransactionHelper.returnUserTransaction(this.ut);
            this.ut = null;
        }
    }
}

