/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.sitemesh.factory;

import com.opensymphony.module.sitemesh.Config;
import com.opensymphony.module.sitemesh.DecoratorMapper;
import com.opensymphony.module.sitemesh.Factory;
import com.opensymphony.module.sitemesh.PageParser;
import com.opensymphony.module.sitemesh.mapper.PathMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public abstract class BaseFactory
extends Factory {
    protected Config config = null;
    protected DecoratorMapper decoratorMapper = null;
    protected Map pageParsers = null;
    protected PathMapper excludeUrls = null;

    protected BaseFactory(Config config) {
        this.config = config;
        this.clearDecoratorMappers();
        this.clearParserMappings();
        this.clearExcludeUrls();
    }

    public DecoratorMapper getDecoratorMapper() {
        return this.decoratorMapper;
    }

    public PageParser getPageParser(String contentType) {
        return (PageParser)this.pageParsers.get(contentType);
    }

    public boolean shouldParsePage(String contentType) {
        return this.pageParsers.containsKey(contentType);
    }

    public boolean isPathExcluded(String path) {
        return this.excludeUrls.get(path) != null;
    }

    protected void clearDecoratorMappers() {
        this.decoratorMapper = null;
    }

    protected void pushDecoratorMapper(String className, Properties properties) {
        try {
            Class<?> decoratorMapperClass = null;
            try {
                decoratorMapperClass = BaseFactory.loadClass(className, this.getClass());
            }
            catch (NoClassDefFoundError e) {
                decoratorMapperClass = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            }
            DecoratorMapper newMapper = (DecoratorMapper)decoratorMapperClass.newInstance();
            newMapper.init(this.config, properties, this.decoratorMapper);
            this.decoratorMapper = newMapper;
        }
        catch (ClassNotFoundException e) {
            BaseFactory.report("Could not load DecoratorMapper class : " + className, e);
        }
        catch (Exception e) {
            BaseFactory.report("Could not initialize DecoratorMapper : " + className, e);
        }
    }

    public static Class loadClass(String className, Class callingClass) throws ClassNotFoundException {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException ex) {
                try {
                    return BaseFactory.class.getClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException exc) {
                    return callingClass.getClassLoader().loadClass(className);
                }
            }
        }
    }

    protected void clearParserMappings() {
        this.pageParsers = new HashMap();
    }

    protected void mapParser(String contentType, String className) {
        if (className.endsWith(".DefaultPageParser")) {
            return;
        }
        try {
            PageParser pp = (PageParser)Class.forName(className).newInstance();
            this.pageParsers.put(contentType, pp);
        }
        catch (ClassNotFoundException e) {
            BaseFactory.report("Could not load PageParser class : " + className, e);
        }
        catch (Exception e) {
            BaseFactory.report("Could not instantiate PageParser : " + className, e);
        }
    }

    protected void addExcludeUrl(String path) {
        this.excludeUrls.put("", path);
    }

    protected void clearExcludeUrls() {
        this.excludeUrls = new PathMapper();
    }
}

