/*
 * Copyright (C) 2007 JasperSoft http://www.jaspersoft.com
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed WITHOUT ANY WARRANTY; and without the 
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt 
 * or write to:
 * 
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */

/** 
 *  \file jsdelete.c
 *  This sample shows how to delete a resource inside the repository.
 *  
 *  \see  jasperserver_ws_delete

*/

#include "../jasperserver/jasperserver.h"

const char server[] = "http://192.168.1.20:8080/jasperserver-pro/services/repository";

/** 
 *  \brief Sample function to delete a resource by URI
 *
 *  \param uri of the resource to delete.
 *  \warning Don't try to delete the uri "/" since it will remove all the content of your repository!
*/
void delete_resource(char *uri)
{
      jasperserver_request_t *request = NULL;
      jasperserver_server_t *jasperServer = NULL;
      jasperserver_resource_descriptor_t *res = NULL;
      jasperserver_operation_result_t *operationResult = NULL;
 
      // Create a new structure of type jasperserver_server_t to save the
      // server url and credentials.
      jasperServer = jasperserver_server_new();
      jasperserver_string_cset(jasperServer->url, server);
      jasperserver_string_cset(jasperServer->username, "jasperadmin|organization_1");
      jasperserver_string_cset(jasperServer->password, "jasperadmin");
     
      // Create a new structure of type jasperserver_request_t to store
      // the request information like the resource to list    
      request = jasperserver_request_new();   
     
      //Creating and populating a new resource_descriptor...
      res = jasperserver_resource_descriptor_new();
      request->resource = res;
      jasperserver_string_cset(res->uriString, uri);
      
      // Call the web service
      operationResult = jasperserver_ws_delete(jasperServer, request);
      
      if (operationResult->returnCode == 0)
      {
         printf("Server version: %s, Return code: '%d', Return message '%s'\n", JS_CSTR( operationResult->version),  operationResult->returnCode, JS_CSTR( operationResult->returnMessage ));
         printf("Deleted resource: %s\n\n", JS_CSTR( request->resource->uriString));
         fflush( stdout );
      }
      else
      {
          //printf("Error executing the service: %d (%s)", operationResult->returnCode, JS_UTFSTR(operationResult->returnMessage) );
          printf("Error executing the service: %d (%s)", operationResult->returnCode, JS_UTFSTR(operationResult->returnMessage) );
      }
                                      
      jasperserver_server_free( jasperServer );
      jasperserver_request_free( request );
      jasperserver_operation_result_free( operationResult );
      
}


int main(int argc, char **argv)
{ 
   char *uri = NULL;
   printf("JasperServer list sample (C) 2007 JasperSoft Corp.!\n");
   
   if (argc > 1)
   {
     uri = argv[1];  
     delete_resource(uri);
   }
   else
   {
     printf("Please specify the URI to delete.\n\n");
   }

  return 0;
}
