%{?mingw_package_header}

#define _version_suffix -e198

%if "%{_build_arch}" == "x86_64" && (0%{?fedora} && 0%{?fedora} >= 24)
    %define can_do_check_x64 1
    %define can_do_check_x86 1
%else
%if "%{_build_arch}" == "x86_64" && (0%{?epel} && 0%{?epel} >= 7)
    %define can_do_check_x64 1
    %define can_do_check_x86 0
%else
    %define can_do_check_x64 0
    %define can_do_check_x86 0
%endif
%endif

Name:           mingw-spice-vdagent
Version:        0.9.0
Release:        1%{?dist}%{?extra_release}
Summary:        MinGW Windows SPICE guest agent

License:        GPLv2+
URL:            https://www.spice-space.org/
Source0:        vdagent-win-0.9.0%{?_version_suffix}.tar.xz

BuildRequires:  mingw32-filesystem >= 23
BuildRequires:  mingw64-filesystem >= 23
BuildRequires:  mingw32-gcc-c++
BuildRequires:  mingw64-gcc-c++
BuildRequires:  mingw32-libpng-static
BuildRequires:  mingw64-libpng-static
BuildRequires:  mingw32-zlib-static
BuildRequires:  mingw64-zlib-static
BuildRequires:  mingw32-winpthreads-static
BuildRequires:  mingw64-winpthreads-static
BuildRequires:  pkgconfig
%if 0%{can_do_check_x64}
BuildRequires:  ImageMagick wine-core(x86-64)
%endif
%if 0%{can_do_check_x86}
BuildRequires:  ImageMagick wine-core(x86-32)
%endif

BuildArch:      noarch

%package -n mingw32-spice-vdagent
Summary:        MinGW Windows SPICE guest agent

%package -n mingw64-spice-vdagent
Summary:        MinGW Windows SPICE guest agent

%description
Spice agent for Windows guests offering the following features:

Features:
* Client mouse mode (no need to grab mouse by client, no mouse lag)
  this is handled by the daemon by feeding mouse events into the kernel
  via uinput.
* Automatic adjustment of the Windows desktop resolution to the client resolution
* Support of copy and paste (text and images) between the active Windows
  session and the client

%description -n mingw32-spice-vdagent
Spice agent for Windows guests offering the following features:

Features:
* Client mouse mode (no need to grab mouse by client, no mouse lag)
  this is handled by the daemon by feeding mouse events into the kernel
  via uinput.
* Automatic adjustment of the Windows desktop resolution to the client resolution
* Support of copy and paste (text and images) between the active Windows
  session and the client

%description -n mingw64-spice-vdagent
Spice agent for Windows guests offering the following features:

Features:
* Client mouse mode (no need to grab mouse by client, no mouse lag)
  this is handled by the daemon by feeding mouse events into the kernel
  via uinput.
* Automatic adjustment of the Windows desktop resolution to the client resolution
* Support of copy and paste (text and images) between the active Windows
  session and the client

%prep
%setup -q -n vdagent-win-0.9.0%{?_version_suffix}

%{mingw_debug_package}

%build
%mingw_configure --enable-debug
%mingw_make %{?_smp_mflags} V=1

%if 0%{can_do_check_x86} || 0%{can_do_check_x64}
%check
%define mingw_build_win32 %{can_do_check_x86}
%define mingw_build_win64 %{can_do_check_x64}
%mingw_make check
%define mingw_build_win32 1
%define mingw_build_win64 1
%endif

%install
%mingw_make_install DESTDIR=$RPM_BUILD_ROOT

%files -n mingw32-spice-vdagent
%defattr(-,root,root)
%{mingw32_bindir}/vdagent.exe
%{mingw32_bindir}/vdservice.exe

%files -n mingw64-spice-vdagent
%defattr(-,root,root)
%{mingw64_bindir}/vdagent.exe
%{mingw64_bindir}/vdservice.exe
