#
# otopi -- plugable installer
# Copyright (C) 2012-2013 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#

%global		package_version 1.3.2
%global		package_maven_version 1.3.0

%if 0%{?fedora:1}
%global _use_maven 1
%endif
%if 0%{?rhel:1}
%if %{rhel} >= 7
%global _use_maven 1
%else
%global _use_maven 0
%global _use_repolib 1
%global maven2brewrepodir %{_javadir}/repository.jboss.com/maven2-brew/dummy
%endif
%endif

Summary:	oVirt Task Oriented Pluggable Installer/Implementation (%{name})
Name:		otopi
Version:	1.3.2
Release:	1%{?release_suffix}%{?dist}
License:	LGPLv2+
URL:		http://www.ovirt.org
Source:		http://resources.ovirt.org/pub/src/%{name}/%{name}-%{package_version}.tar.gz
Group:		Development/Libraries

BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildArch:	noarch

Requires:	python
BuildRequires:	gettext
BuildRequires:	python2-devel
BuildRequires:	java-devel

%if %{_use_maven}
BuildRequires:	apache-commons-logging
BuildRequires:	junit
BuildRequires:	maven-compiler-plugin
BuildRequires:	maven-enforcer-plugin
BuildRequires:	maven-install-plugin
BuildRequires:	maven-jar-plugin
BuildRequires:	maven-javadoc-plugin
BuildRequires:	maven-source-plugin
BuildRequires:	maven-surefire-provider-junit
BuildRequires:	maven-local
%else
BuildRequires:	jpackage-utils
BuildRequires:	jakarta-commons-logging
BuildRequires:	junit4
%endif

%description
Standalone plugin based installation framework to be used to setup
system components. The plugin nature provides simplicity to
add new installation functionality without the complexity of the state
and transaction management.

%package java
Summary:	%{name} java support
Requires:	%{name} = %{version}-%{release}
Requires:	java
%if %{_use_maven}
Requires:	apache-commons-logging
%else
Requires:	jakarta-commons-logging
%endif
%description java
java libraries.

%if %{_use_maven}
%package javadoc
Summary:	Javadocs for %{name}
Group:		Documentation

%description javadoc
This package contains the API documentation for %{name}.
%endif

%package devtools
Summary:	%{name} development tools
Requires:	%{name} = %{version}-%{release}
Obsoletes:	%{name}-devel < 1.2.0
Provides:	%{name}-devel = %{version}-%{release}
%description devtools
Development tools for %{name}.

%if 0%{?_use_repolib:1}
%package repolib
Summary:	%{name} maven repo
%description repolib
%{name} maven repo
%endif

%prep
%setup -q -n %{name}-%{package_version}

%build
%if %{_use_maven}
%global conf --disable-java-sdk-compile
%else
%global conf COMMONS_LOGGING_JAR=$(build-classpath commons-logging) JUNIT_JAR=$((build-classpath junit4 || build-classpath junit) | sed '/^$/d')
%endif
%configure \
	--docdir="%{_docdir}/%{name}-%{version}" \
	--disable-python-syntax-check \
	--enable-java-sdk \
	--with-local-version="%{name}-%{version}-%{release}" \
	%{?conf}
make %{?_smp_mflags}

%if %{_use_maven}
cd src/java
%mvn_build
cd ../..
%endif

%install
rm -rf "%{buildroot}"
make %{?_smp_mflags} install DESTDIR="%{buildroot}"

%if %{_use_maven}
cd src/java
%mvn_install
cd ../..
%else
install -d "%{buildroot}%{_javadir}/%{name}"
install target/%{name}-%{package_maven_version}.jar "%{buildroot}%{_javadir}/%{name}"
ln -s %{name}-%{package_maven_version}.jar "%{buildroot}%{_javadir}/%{name}/%{name}.jar"
cat > src/java/.mfiles << __EOF__
%{_javadir}/%{name}/
__EOF__

install -d "%{buildroot}%{maven2brewrepodir}"
cp "%{buildroot}%{_javadir}/%{name}/%{name}.jar" "%{buildroot}%{maven2brewrepodir}/%{name}-%{package_maven_version}.jar"
cp src/java/pom.xml "%{buildroot}%{maven2brewrepodir}/%{name}-%{package_maven_version}.pom"
%endif

install -d -m 755 "%{buildroot}%{_sysconfdir}/%{name}.conf.d"

%files
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/plugins
%dir %{_sysconfdir}/%{name}.conf.d
%doc AUTHORS
%doc COPYING
%doc README
%doc README.API
%doc README.dialog
%doc README.environment
%exclude %{python_sitelib}/%{name}/codegen/
%{_datadir}/%{name}/plugins/%{name}/
%{_sbindir}/%{name}
%{python_sitelib}/%{name}/

%files java -f src/java/.mfiles

%if %{_use_maven}
%files javadoc -f src/java/.mfiles-javadoc
%endif

%files devtools
%{_datadir}/%{name}/%{name}-bundle
%{python_sitelib}/%{name}/codegen/

%if 0%{?_use_repolib:1}
%files repolib
%{maven2brewrepodir}/
%endif

%changelog
* Tue May 12 2015 Alon Bar-Lev <alonbl@redhat.com> - 1.3.2-1
- Release.

* Thu Jan 15 2015 Alon Bar-Lev <alonbl@redhat.com> - 1.3.1-1
- Release.

* Mon Oct 6 2014 Alon Bar-Lev <alonbl@redhat.com> - 1.3.0-1
- Release.

* Fri May 2 2014 Alon Bar-Lev <alonbl@redhat.com> - 1.2.1-1
- Release.

* Tue Mar 18 2014 Alon Bar-Lev <alonbl@redhat.com> - 1.2.0-1
- Release.

* Wed Mar 12 2014 Alon Bar-Lev <alonbl@redhat.com> - 1.2.0-0.11.rc4
- Release candidate.

* Tue Mar 11 2014 Alon Bar-Lev <alonbl@redhat.com> - 1.2.0-0.9.rc3
- Release candidate.

* Thu Feb 27 2014 Alon Bar-Lev <alonbl@redhat.com> - 1.2.0-0.7.rc2
- Release candidate.

* Thu Feb 27 2014 Alon Bar-Lev <alonbl@redhat.com> - 1.2.0-0.5.rc
- Release candidate.

* Mon Feb 17 2014 Alon Bar-Lev <alonbl@redhat.com> - 1.2.0-0.3.beta2
- Beta.

* Mon Jan 20 2014 Alon Bar-Lev <alonbl@redhat.com> - 1.2.0-0.1.beta
- Beta.

* Mon Aug 26 2013 Alon Bar-Lev <alonbl@redhat.com> - 1.1.0-1
- Release.

* Thu Feb 14 2013 Alon Bar-Lev <alonbl@redhat.com> - 1.0.0-1
- Release.

* Sat Oct 13 2012 Alon Bar-Lev <alonbl@redhat.com> - 1.0.0-0.1_beta
- Initial add.
