/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.client.transport;

import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.jboss.logging.Logger;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.ClientSocketChannelFactory;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.api.util.ServiceLoader;
import org.jboss.ws.core.client.transport.ClientSocketChannelFactoryProvider;
import org.jboss.ws.core.client.transport.DefaultClientSocketChannelFactoryProvider;
import org.jboss.ws.core.client.transport.KeepAliveCache;
import org.jboss.ws.core.client.transport.NettyHelper;

public class NettyTransportHandler {
    private static final ResourceBundle bundle = BundleUtils.getBundle(NettyTransportHandler.class);
    private static Logger log = Logger.getLogger(NettyTransportHandler.class);
    private static final int DEFAULT_KEEP_ALIVE_CONS = 5;
    private URL url;
    private ChannelFuture connectFuture;
    private Channel channel;
    private static ClientSocketChannelFactoryProvider factoryProvider;
    private static KeepAliveCache cache;
    private static boolean keepAliveProp;
    private boolean inCache;
    private volatile boolean keepingAlive = true;
    private int keepAliveConnections = 5;
    private int keepAliveTimeout;

    private NettyTransportHandler(URL url, ChannelPipelineFactory pipelineFactory) {
        this.url = url;
        ClientSocketChannelFactory factory = factoryProvider.getClientSocketChannelFactoryInstance();
        ClientBootstrap bootstrap = new ClientBootstrap((ChannelFactory)factory);
        bootstrap.setPipelineFactory(pipelineFactory);
        bootstrap.setOption("tcpNoDelay", (Object)true);
        this.connectFuture = bootstrap.connect((SocketAddress)this.getSocketAddress(url));
    }

    public static NettyTransportHandler getInstance(URL url, ChannelPipelineFactory pipelineFactory) {
        return NettyTransportHandler.getInstance(url, true, pipelineFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NettyTransportHandler getInstance(URL url, boolean useCache, ChannelPipelineFactory pipelineFactory) {
        NettyTransportHandler ret = null;
        if (useCache && keepAliveProp && (ret = cache.get(url)) != null) {
            NettyTransportHandler nettyTransportHandler = ret;
            synchronized (nettyTransportHandler) {
                ret.inCache = false;
            }
        }
        if (ret == null) {
            ret = new NettyTransportHandler(url, pipelineFactory);
        } else {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkConnect(url.getHost(), url.getPort());
            }
            ret.url = url;
        }
        return ret;
    }

    public Channel getChannel() throws ConnectException {
        return this.getChannel(null);
    }

    public Channel getChannel(Long timeout) throws ConnectException {
        if (this.channel == null && this.connectFuture != null) {
            NettyHelper.awaitUninterruptibly(this.connectFuture, timeout);
            if (!this.connectFuture.isSuccess()) {
                ConnectException ce = new ConnectException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"COULD_NOT_CONNECT_TO", (Object[])new Object[]{this.url.getHost()}));
                ce.initCause(this.connectFuture.getCause());
                throw ce;
            }
            this.channel = this.connectFuture.getChannel();
        }
        return this.channel;
    }

    public void goOn(Map<String, Object> metadata, Map<String, Object> headers) {
        this.checkKeepAliveHeaders(metadata, headers);
    }

    public void finished(Map<String, Object> metadata, Map<String, Object> headers) {
        this.checkKeepAliveHeaders(metadata, headers);
        --this.keepAliveConnections;
        if (this.keepAliveConnections > 0 && this.isKeepingAlive()) {
            this.putInKeepAliveCache();
        } else {
            this.end();
        }
    }

    protected void checkKeepAliveHeaders(Map<String, Object> metadata, Map<String, Object> headers) {
        if (headers == null || metadata == null) {
            return;
        }
        this.keepAliveConnections = -1;
        this.keepAliveTimeout = 0;
        try {
            String connectionHeader = NettyHelper.getFirstHeaderAsString(headers, "Connection");
            if (connectionHeader != null && connectionHeader.equalsIgnoreCase("keep-alive")) {
                String keepAliveHeader = NettyHelper.getFirstHeaderAsString(headers, "Keep-Alive");
                if (keepAliveHeader != null) {
                    StringTokenizer st = new StringTokenizer(keepAliveHeader, ", ", false);
                    while (st.hasMoreTokens()) {
                        this.keepAliveTimeout = 5;
                        this.keepAliveConnections = 5;
                        String s = st.nextToken();
                        if (s.startsWith("timeout=")) {
                            this.keepAliveTimeout = Integer.parseInt(s.substring(8));
                        }
                        if (!s.startsWith("max=")) continue;
                        this.keepAliveConnections = Integer.parseInt(s.substring(4));
                    }
                }
            } else if (HttpVersion.HTTP_1_1.toString().equals(NettyHelper.getFirstHeaderAsString(metadata, "org.jboss.ws.core.client.transport.NettyClient#Protocol"))) {
                int n = this.keepAliveConnections = connectionHeader == null ? 5 : 1;
            }
            if (this.keepAliveConnections <= 1) {
                this.keepingAlive = false;
            }
        }
        catch (Exception ex) {
            log.error((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"ERROR_WHILE_PARSING_HEADERS", (Object[])new Object[0]), (Throwable)ex);
            this.keepAliveConnections = -1;
            this.keepingAlive = false;
        }
    }

    protected synchronized void putInKeepAliveCache() {
        if (this.inCache) {
            return;
        }
        this.inCache = true;
        cache.put(this.url, this);
    }

    private InetSocketAddress getSocketAddress(URL target) {
        int port = target.getPort();
        if (port < 0) {
            String protocol = target.getProtocol();
            if ("http".equalsIgnoreCase(protocol)) {
                port = 80;
            } else if ("https".equalsIgnoreCase(protocol)) {
                port = 443;
            }
        }
        return new InetSocketAddress(target.getHost(), port);
    }

    public void end() {
        this.keepingAlive = false;
        if (this.channel == null) {
            this.channel = this.connectFuture.getChannel();
            this.connectFuture.cancel();
        }
        if (this.channel != null) {
            this.channel.close();
        }
    }

    public static boolean getHttpKeepAliveSet() {
        return keepAliveProp;
    }

    protected boolean isKeepingAlive() {
        return NettyTransportHandler.getHttpKeepAliveSet() && this.keepingAlive;
    }

    public int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setKeepAliveConnections(int keepAliveConnections) {
        this.keepAliveConnections = keepAliveConnections;
    }

    static {
        cache = new KeepAliveCache();
        keepAliveProp = true;
        String keepAlive = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("org.jboss.ws.http.keepAlive");
            }
        });
        keepAliveProp = keepAlive != null ? Boolean.valueOf(keepAlive) : true;
        factoryProvider = (ClientSocketChannelFactoryProvider)ServiceLoader.loadService((String)ClientSocketChannelFactoryProvider.class.getName(), (String)DefaultClientSocketChannelFactoryProvider.class.getName(), (ClassLoader)NettyTransportHandler.class.getClassLoader());
    }
}

