/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.binding.jbossxb;

import java.io.InputStream;
import java.util.HashMap;
import java.util.ResourceBundle;
import org.jboss.ws.WSException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.core.jaxrpc.binding.jbossxb.JBossXBSupport;
import org.jboss.ws.core.jaxrpc.binding.jbossxb.JBossXBUnmarshaller;
import org.jboss.ws.core.jaxrpc.binding.jbossxb.UnmarshalException;
import org.jboss.ws.extensions.xop.jaxrpc.XOPUnmarshallerImpl;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.xop.XOPUnmarshaller;

public class JBossXBUnmarshallerImpl
implements JBossXBUnmarshaller {
    private static final ResourceBundle bundle = BundleUtils.getBundle(JBossXBUnmarshallerImpl.class);
    private HashMap<String, Object> properties = new HashMap();

    @Override
    public Object unmarshal(InputStream is) throws UnmarshalException {
        this.assertRequiredProperties();
        Unmarshaller unm = UnmarshallerFactory.newInstance().newUnmarshaller();
        SchemaBinding schemaBinding = JBossXBSupport.getOrCreateSchemaBinding(this.properties);
        XOPUnmarshallerImpl xopUnmarshaller = new XOPUnmarshallerImpl();
        schemaBinding.setXopUnmarshaller((XOPUnmarshaller)xopUnmarshaller);
        try {
            return unm.unmarshal(is, schemaBinding);
        }
        catch (JBossXBException e) {
            throw new UnmarshalException(e.getMessage(), e);
        }
    }

    @Override
    public Object getProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"NAME_PARAMETER_IS_NULL", (Object[])new Object[0]));
        }
        return this.properties.get(name);
    }

    @Override
    public void setProperty(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"NAME_PARAMETER_IS_NULL", (Object[])new Object[0]));
        }
        this.properties.put(name, value);
    }

    private void assertRequiredProperties() {
        if (this.getProperty("org.jboss.xb.xsd.xsmodel") == null) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_FIND_REQUIRED_PROPERTY", (Object[])new Object[]{"org.jboss.xb.xsd.xsmodel"}));
        }
        if (this.getProperty("org.jboss.xb.java.mapping") == null) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_FIND_REQUIRED_PROPERTY", (Object[])new Object[]{"org.jboss.xb.java.mapping"}));
        }
    }
}

