/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.wsdl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import org.jboss.ws.WSException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.metadata.wsdl.Extendable;
import org.jboss.ws.metadata.wsdl.WSDLBinding;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperation;
import org.jboss.ws.metadata.wsdl.WSDLDocumentation;
import org.jboss.ws.metadata.wsdl.WSDLInterface;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationInfault;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationInput;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutfault;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutput;
import org.jboss.ws.metadata.wsdl.WSDLProperty;
import org.jboss.ws.metadata.wsdl.WSDLRPCSignatureItem;

public class WSDLInterfaceOperation
extends Extendable
implements Comparable {
    private static final ResourceBundle bundle = BundleUtils.getBundle(WSDLInterfaceOperation.class);
    private static final long serialVersionUID = -5014918078197942626L;
    private WSDLInterface wsdlInterface;
    private final QName name;
    private String pattern;
    private String style = "http://www.w3.org/2004/03/wsdl/style/rpc";
    private boolean safe;
    private Map<QName, WSDLInterfaceOperationInput> inputs = new LinkedHashMap<QName, WSDLInterfaceOperationInput>();
    private Map<QName, WSDLInterfaceOperationOutput> outputs = new LinkedHashMap<QName, WSDLInterfaceOperationOutput>();
    private ArrayList<WSDLInterfaceOperationInfault> infaults = new ArrayList();
    private ArrayList<WSDLInterfaceOperationOutfault> outfaults = new ArrayList();
    private LinkedHashMap<String, WSDLRPCSignatureItem> rpcSignatureItems = new LinkedHashMap();
    private WSDLDocumentation documentationElement;

    public WSDLInterfaceOperation(WSDLInterface wsdlInterface, QName name) {
        this.name = name;
        this.wsdlInterface = wsdlInterface;
    }

    public WSDLInterfaceOperation(WSDLInterface wsdlInterface, String localName) {
        this.wsdlInterface = wsdlInterface;
        this.name = new QName(wsdlInterface.getName().getNamespaceURI(), localName);
    }

    public WSDLInterface getWsdlInterface() {
        return this.wsdlInterface;
    }

    public QName getName() {
        return this.name;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public boolean isSafe() {
        return this.safe;
    }

    public void setSafe(boolean safe) {
        this.safe = safe;
    }

    public WSDLInterfaceOperationInput[] getInputs() {
        WSDLInterfaceOperationInput[] arr = new WSDLInterfaceOperationInput[this.inputs.size()];
        new ArrayList<WSDLInterfaceOperationInput>(this.inputs.values()).toArray(arr);
        return arr;
    }

    public void addInput(WSDLInterfaceOperationInput input) {
        QName xmlName = input.getElement();
        if (this.inputs.get(xmlName) != null) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"MAP_MULTIPLE_INPUTS", (Object[])new Object[]{xmlName}));
        }
        this.inputs.put(xmlName, input);
    }

    public WSDLInterfaceOperationInput getInput(QName qname) {
        WSDLInterfaceOperationInput opInput = this.inputs.get(qname);
        return opInput;
    }

    public void removeInput(QName element) {
        this.inputs.remove(element);
    }

    public WSDLInterfaceOperationInput getInputByPartName(String partName) {
        WSDLInterfaceOperationInput opInput = null;
        for (WSDLInterfaceOperationInput auxInput : this.inputs.values()) {
            WSDLProperty property = auxInput.getProperty("http://www.jboss.org/jbossws/partname");
            if (property == null || !property.getValue().equals(partName)) continue;
            opInput = auxInput;
        }
        return opInput;
    }

    public WSDLInterfaceOperationOutput[] getOutputs() {
        WSDLInterfaceOperationOutput[] arr = new WSDLInterfaceOperationOutput[this.outputs.size()];
        new ArrayList<WSDLInterfaceOperationOutput>(this.outputs.values()).toArray(arr);
        return arr;
    }

    public void addOutput(WSDLInterfaceOperationOutput output) {
        QName xmlName = output.getElement();
        if (this.outputs.get(xmlName) != null) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"MAP_MULTIPLE_OUTPUTS", (Object[])new Object[]{xmlName}));
        }
        this.outputs.put(xmlName, output);
    }

    public WSDLInterfaceOperationOutput getOutput(QName qname) {
        WSDLInterfaceOperationOutput opOutput = this.outputs.get(qname);
        return opOutput;
    }

    public void removeOutput(QName element) {
        this.outputs.remove(element);
    }

    public WSDLInterfaceOperationOutput getOutputByPartName(String partName) {
        WSDLInterfaceOperationOutput opOutput = null;
        for (WSDLInterfaceOperationOutput auxOutput : this.outputs.values()) {
            WSDLProperty property = auxOutput.getProperty("http://www.jboss.org/jbossws/partname");
            if (property == null || !property.getValue().equals(partName)) continue;
            opOutput = auxOutput;
        }
        return opOutput;
    }

    public WSDLInterfaceOperationInfault[] getInfaults() {
        WSDLInterfaceOperationInfault[] arr = new WSDLInterfaceOperationInfault[this.infaults.size()];
        this.infaults.toArray(arr);
        return arr;
    }

    public void addInfault(WSDLInterfaceOperationInfault infault) {
        this.infaults.add(infault);
    }

    public WSDLInterfaceOperationOutfault[] getOutfaults() {
        WSDLInterfaceOperationOutfault[] arr = new WSDLInterfaceOperationOutfault[this.outfaults.size()];
        this.outfaults.toArray(arr);
        return arr;
    }

    public void addOutfault(WSDLInterfaceOperationOutfault outfault) {
        this.outfaults.add(outfault);
    }

    public Collection<WSDLRPCSignatureItem> getRpcSignatureItems() {
        return this.rpcSignatureItems.values();
    }

    public void addRpcSignatureItem(WSDLRPCSignatureItem item) {
        if (item.getDirection() != WSDLRPCSignatureItem.Direction.RETURN) {
            item.setPosition(this.rpcSignatureItems.size());
        }
        this.rpcSignatureItems.put(item.getName(), item);
    }

    public WSDLRPCSignatureItem getRpcSignatureitem(String name) {
        return this.rpcSignatureItems.get(name);
    }

    public WSDLBindingOperation getBindingOperation() {
        WSDLInterface wsdlInterface = this.getWsdlInterface();
        WSDLBinding binding = wsdlInterface.getWsdlDefinitions().getBindingByInterfaceName(wsdlInterface.getName());
        if (binding == null) {
            return null;
        }
        WSDLBindingOperation bindingOperation = binding.getOperationByRef(this.getName());
        return bindingOperation;
    }

    public int compareTo(Object o) {
        int c = -1;
        if (o instanceof WSDLInterfaceOperation) {
            WSDLInterfaceOperation w = (WSDLInterfaceOperation)o;
            String oname = w.getName().getLocalPart();
            String myname = this.name.getLocalPart();
            c = myname.compareTo(oname);
        }
        return c;
    }

    public WSDLDocumentation getDocumentationElement() {
        return this.documentationElement;
    }

    public void setDocumentationElement(WSDLDocumentation documentationElement) {
        this.documentationElement = documentationElement;
    }
}

