/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.validate;

import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.NamePasswordCallbackHandler;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.message.token.UsernameToken;
import org.apache.ws.security.validate.Credential;
import org.apache.ws.security.validate.Validator;

public class JAASUsernameTokenValidator
implements Validator {
    private static Log log = LogFactory.getLog(JAASUsernameTokenValidator.class);
    private String contextName = null;

    public void setContextName(String name) {
        this.contextName = name;
    }

    public String getContextName() {
        return this.contextName;
    }

    public Credential validate(Credential credential, RequestData data) throws WSSecurityException {
        if (credential == null || credential.getUsernametoken() == null) {
            throw new WSSecurityException(0, "noCredential");
        }
        String user = null;
        String password = null;
        UsernameToken usernameToken = credential.getUsernametoken();
        user = usernameToken.getName();
        String pwType = usernameToken.getPasswordType();
        if (log.isDebugEnabled()) {
            log.debug((Object)("UsernameToken user " + usernameToken.getName()));
            log.debug((Object)("UsernameToken password type " + pwType));
        }
        if (usernameToken.isHashed()) {
            log.warn((Object)"Authentication failed as hashed username token not supported");
            throw new WSSecurityException(5);
        }
        password = usernameToken.getPassword();
        if (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText".equals(pwType)) {
            log.warn((Object)("Password type " + pwType + " not supported"));
            throw new WSSecurityException(5);
        }
        if (user == null || user.length() <= 0 || password == null || password.length() <= 0) {
            log.warn((Object)"User or password empty");
            throw new WSSecurityException(5);
        }
        try {
            CallbackHandler handler = this.getCallbackHandler(user, password);
            LoginContext ctx = new LoginContext(this.getContextName(), handler);
            ctx.login();
            ctx.getSubject();
        }
        catch (LoginException ex) {
            log.info((Object)"Authentication failed", (Throwable)ex);
            throw new WSSecurityException(5);
        }
        return credential;
    }

    protected CallbackHandler getCallbackHandler(String name, String password) {
        return new NamePasswordCallbackHandler(name, password);
    }
}

