/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.scout.registry;

import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.LifeCycleManager;
import javax.xml.registry.RegistryService;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.LocalizedString;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.scout.model.uddi.v2.AssertionStatusItem;
import org.apache.ws.scout.model.uddi.v2.AssertionStatusReport;
import org.apache.ws.scout.model.uddi.v2.AuthToken;
import org.apache.ws.scout.model.uddi.v2.BindingDetail;
import org.apache.ws.scout.model.uddi.v2.BindingTemplate;
import org.apache.ws.scout.model.uddi.v2.BusinessDetail;
import org.apache.ws.scout.model.uddi.v2.BusinessInfo;
import org.apache.ws.scout.model.uddi.v2.BusinessInfos;
import org.apache.ws.scout.model.uddi.v2.BusinessList;
import org.apache.ws.scout.model.uddi.v2.BusinessService;
import org.apache.ws.scout.model.uddi.v2.FindQualifiers;
import org.apache.ws.scout.model.uddi.v2.KeyedReference;
import org.apache.ws.scout.model.uddi.v2.Name;
import org.apache.ws.scout.model.uddi.v2.ObjectFactory;
import org.apache.ws.scout.model.uddi.v2.PublisherAssertion;
import org.apache.ws.scout.model.uddi.v2.PublisherAssertions;
import org.apache.ws.scout.model.uddi.v2.RegisteredInfo;
import org.apache.ws.scout.model.uddi.v2.ServiceDetail;
import org.apache.ws.scout.model.uddi.v2.ServiceInfo;
import org.apache.ws.scout.model.uddi.v2.ServiceInfos;
import org.apache.ws.scout.model.uddi.v2.ServiceList;
import org.apache.ws.scout.model.uddi.v2.TModel;
import org.apache.ws.scout.model.uddi.v2.TModelDetail;
import org.apache.ws.scout.model.uddi.v2.TModelInfo;
import org.apache.ws.scout.model.uddi.v2.TModelInfos;
import org.apache.ws.scout.model.uddi.v2.TModelList;
import org.apache.ws.scout.registry.AuthTokenSingleton;
import org.apache.ws.scout.registry.BulkResponseImpl;
import org.apache.ws.scout.registry.BusinessLifeCycleManagerImpl;
import org.apache.ws.scout.registry.ConnectionImpl;
import org.apache.ws.scout.registry.IRegistry;
import org.apache.ws.scout.registry.RegistryException;
import org.apache.ws.scout.registry.RegistryServiceImpl;
import org.apache.ws.scout.registry.infomodel.AssociationImpl;
import org.apache.ws.scout.registry.infomodel.ClassificationSchemeImpl;
import org.apache.ws.scout.registry.infomodel.ConceptImpl;
import org.apache.ws.scout.registry.infomodel.InternationalStringImpl;
import org.apache.ws.scout.registry.infomodel.KeyImpl;
import org.apache.ws.scout.registry.infomodel.ServiceBindingImpl;
import org.apache.ws.scout.registry.infomodel.ServiceImpl;
import org.apache.ws.scout.util.EnumerationHelper;
import org.apache.ws.scout.util.ScoutJaxrUddiHelper;
import org.apache.ws.scout.util.ScoutUddiJaxrHelper;

public class BusinessQueryManagerImpl
implements BusinessQueryManager {
    private final RegistryServiceImpl registryService;
    private Log log = LogFactory.getLog(this.getClass());
    private static ObjectFactory objectFactory = new ObjectFactory();

    public BusinessQueryManagerImpl(RegistryServiceImpl registry) {
        this.registryService = registry;
    }

    public RegistryService getRegistryService() {
        return this.registryService;
    }

    public BulkResponse findOrganizations(Collection findQualifiers, Collection namePatterns, Collection classifications, Collection specifications, Collection externalIdentifiers, Collection externalLinks) throws JAXRException {
        IRegistry registry = (IRegistry)this.registryService.getRegistry();
        try {
            FindQualifiers juddiFindQualifiers = BusinessQueryManagerImpl.mapFindQualifiers(findQualifiers);
            Name[] nameArray = BusinessQueryManagerImpl.mapNamePatterns(namePatterns);
            BusinessList result = registry.findBusiness(nameArray, null, ScoutJaxrUddiHelper.getIdentifierBagFromExternalIdentifiers(externalIdentifiers), ScoutJaxrUddiHelper.getCategoryBagFromClassifications(classifications), null, juddiFindQualifiers, this.registryService.getMaxRows());
            BusinessInfo[] bizInfoArr = null;
            BusinessInfos bizInfos = result.getBusinessInfos();
            LinkedHashSet<Organization> orgs = new LinkedHashSet<Organization>();
            if (bizInfos != null) {
                List<BusinessInfo> bizInfoList = bizInfos.getBusinessInfo();
                for (BusinessInfo businessInfo : bizInfoList) {
                    BusinessDetail detail = registry.getBusinessDetail(businessInfo.getBusinessKey());
                    orgs.add(((BusinessLifeCycleManagerImpl)this.registryService.getLifeCycleManagerImpl()).createOrganization(detail));
                }
                bizInfoArr = new BusinessInfo[bizInfoList.size()];
                bizInfoList.toArray(bizInfoArr);
            }
            return new BulkResponseImpl(orgs);
        }
        catch (RegistryException e) {
            throw new JAXRException((Throwable)e);
        }
    }

    public BulkResponse findAssociations(Collection findQualifiers, String sourceObjectId, String targetObjectId, Collection associationTypes) throws JAXRException {
        IRegistry registry = (IRegistry)this.registryService.getRegistry();
        try {
            ConnectionImpl con = ((RegistryServiceImpl)this.getRegistryService()).getConnection();
            AuthToken auth = this.getAuthToken(con, registry);
            PublisherAssertions result = null;
            try {
                result = registry.getPublisherAssertions(auth.getAuthInfo());
            }
            catch (RegistryException rve) {
                String username = this.getUsernameFromCredentials(con.getCredentials());
                if (AuthTokenSingleton.getToken(username) != null) {
                    AuthTokenSingleton.deleteAuthToken(username);
                }
                auth = this.getAuthToken(con, registry);
                result = registry.getPublisherAssertions(auth.getAuthInfo());
            }
            List<PublisherAssertion> publisherAssertionList = result.getPublisherAssertion();
            LinkedHashSet<Association> col = new LinkedHashSet<Association>();
            for (PublisherAssertion pas : publisherAssertionList) {
                String sourceKey = pas.getFromKey();
                String targetKey = pas.getToKey();
                if (sourceObjectId != null && !sourceObjectId.equals(sourceKey) || targetObjectId != null && !targetObjectId.equals(targetKey)) continue;
                ArrayList<KeyImpl> orgcol = new ArrayList<KeyImpl>();
                orgcol.add(new KeyImpl(sourceKey));
                orgcol.add(new KeyImpl(targetKey));
                BulkResponse bl = this.getRegistryObjects(orgcol, "Organization");
                Association asso = ScoutUddiJaxrHelper.getAssociation(bl.getCollection(), (LifeCycleManager)this.registryService.getBusinessLifeCycleManager());
                KeyedReference keyr = pas.getKeyedReference();
                ConceptImpl c = new ConceptImpl((LifeCycleManager)this.getRegistryService().getBusinessLifeCycleManager());
                c.setName(new InternationalStringImpl(keyr.getKeyName()));
                c.setKey(new KeyImpl(keyr.getTModelKey()));
                c.setValue(keyr.getKeyValue());
                asso.setAssociationType((Concept)c);
                col.add(asso);
            }
            return new BulkResponseImpl(col);
        }
        catch (RegistryException e) {
            throw new JAXRException((Throwable)e);
        }
    }

    public BulkResponse findCallerAssociations(Collection findQualifiers, Boolean confirmedByCaller, Boolean confirmedByOtherParty, Collection associationTypes) throws JAXRException {
        IRegistry registry = (IRegistry)this.registryService.getRegistry();
        try {
            ConnectionImpl con = ((RegistryServiceImpl)this.getRegistryService()).getConnection();
            AuthToken auth = this.getAuthToken(con, registry);
            AssertionStatusReport report = null;
            String confirm = "";
            boolean caller = confirmedByCaller;
            boolean other = confirmedByOtherParty;
            if (caller && other) {
                confirm = "status:complete";
            } else if (!caller && other) {
                confirm = "status:fromKey_incomplete";
            } else if (caller && !other) {
                confirm = "status:toKey_incomplete";
            }
            report = null;
            try {
                report = registry.getAssertionStatusReport(auth.getAuthInfo(), confirm);
            }
            catch (RegistryException rve) {
                String username = this.getUsernameFromCredentials(con.getCredentials());
                if (AuthTokenSingleton.getToken(username) != null) {
                    AuthTokenSingleton.deleteAuthToken(username);
                }
                auth = this.getAuthToken(con, registry);
                report = registry.getAssertionStatusReport(auth.getAuthInfo(), confirm);
            }
            List<AssertionStatusItem> assertionStatusItemList = report.getAssertionStatusItem();
            LinkedHashSet<Association> col = new LinkedHashSet<Association>();
            for (AssertionStatusItem asi : assertionStatusItemList) {
                String sourceKey = asi.getFromKey();
                String targetKey = asi.getToKey();
                ArrayList<KeyImpl> orgcol = new ArrayList<KeyImpl>();
                orgcol.add(new KeyImpl(sourceKey));
                orgcol.add(new KeyImpl(targetKey));
                BulkResponse bl = this.getRegistryObjects(orgcol, "Organization");
                Association asso = ScoutUddiJaxrHelper.getAssociation(bl.getCollection(), (LifeCycleManager)this.registryService.getBusinessLifeCycleManager());
                ((AssociationImpl)asso).setConfirmedBySourceOwner(caller);
                ((AssociationImpl)asso).setConfirmedByTargetOwner(other);
                if (confirm != "status:complete") {
                    ((AssociationImpl)asso).setConfirmed(false);
                }
                ConceptImpl c = new ConceptImpl((LifeCycleManager)this.getRegistryService().getBusinessLifeCycleManager());
                KeyedReference keyr = asi.getKeyedReference();
                c.setKey(new KeyImpl(keyr.getTModelKey()));
                c.setName(new InternationalStringImpl(keyr.getKeyName()));
                c.setValue(keyr.getKeyValue());
                asso.setKey((Key)new KeyImpl(keyr.getTModelKey()));
                asso.setAssociationType((Concept)c);
                col.add(asso);
            }
            return new BulkResponseImpl(col);
        }
        catch (RegistryException e) {
            throw new JAXRException((Throwable)e);
        }
    }

    public ClassificationScheme findClassificationSchemeByName(Collection findQualifiers, String namePatterns) throws JAXRException {
        ClassificationSchemeImpl scheme = null;
        if (namePatterns.indexOf("uddi-org:types") != -1) {
            scheme = new ClassificationSchemeImpl((LifeCycleManager)this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:C1ACF26D-9672-4404-9D70-39B756E62AB4"));
        } else if (namePatterns.indexOf("dnb-com:D-U-N-S") != -1) {
            scheme = new ClassificationSchemeImpl((LifeCycleManager)this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:8609C81E-EE1F-4D5A-B202-3EB13AD01823"));
        } else if (namePatterns.indexOf("uddi-org:iso-ch:3166:1999") != -1) {
            scheme = new ClassificationSchemeImpl((LifeCycleManager)this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:4E49A8D6-D5A2-4FC2-93A0-0411D8D19E88"));
        } else if (namePatterns.indexOf("uddi-org:iso-ch:3166-1999") != -1) {
            scheme = new ClassificationSchemeImpl((LifeCycleManager)this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:4E49A8D6-D5A2-4FC2-93A0-0411D8D19E88"));
        } else if (namePatterns.indexOf("iso-ch:3166:1999") != -1) {
            scheme = new ClassificationSchemeImpl((LifeCycleManager)this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:4E49A8D6-D5A2-4FC2-93A0-0411D8D19E88"));
        } else if (namePatterns.indexOf("iso-ch:3166-1999") != -1) {
            scheme = new ClassificationSchemeImpl((LifeCycleManager)this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:4E49A8D6-D5A2-4FC2-93A0-0411D8D19E88"));
        } else if (namePatterns.indexOf("unspsc-org:unspsc") != -1) {
            scheme = new ClassificationSchemeImpl((LifeCycleManager)this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:DB77450D-9FA8-45D4-A7BC-04411D14E384"));
        } else if (namePatterns.indexOf("ntis-gov:naics") != -1) {
            scheme = new ClassificationSchemeImpl((LifeCycleManager)this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:C0B9FE13-179F-413D-8A5B-5004DB8E5BB2"));
        } else if ("AssociationType".equals(namePatterns)) {
            scheme = new ClassificationSchemeImpl((LifeCycleManager)this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:DB77450D-9FA8-45D4-A7BC-04411D14E384"));
            this.addChildConcept(scheme, "RelatedTo");
            this.addChildConcept(scheme, "HasChild");
            this.addChildConcept(scheme, "HasMember");
            this.addChildConcept(scheme, "HasParent");
            this.addChildConcept(scheme, "ExternallyLinks");
            this.addChildConcept(scheme, "Contains");
            this.addChildConcept(scheme, "EquivalentTo");
            this.addChildConcept(scheme, "Extends");
            this.addChildConcept(scheme, "Implements");
            this.addChildConcept(scheme, "InstanceOf");
            this.addChildConcept(scheme, "Supersedes");
            this.addChildConcept(scheme, "Uses");
            this.addChildConcept(scheme, "Replaces");
            this.addChildConcept(scheme, "ResponsibleFor");
            this.addChildConcept(scheme, "SubmitterOf");
        } else if ("ObjectType".equals(namePatterns)) {
            scheme = new ClassificationSchemeImpl((LifeCycleManager)this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:DB77450D-9FA8-45D4-A7BC-04411D14E384"));
            this.addChildConcept(scheme, "CPP");
            this.addChildConcept(scheme, "CPA");
            this.addChildConcept(scheme, "Process");
            this.addChildConcept(scheme, "WSDL");
            this.addChildConcept(scheme, "Association");
            this.addChildConcept(scheme, "AuditableEvent");
            this.addChildConcept(scheme, "Classification");
            this.addChildConcept(scheme, "Concept");
            this.addChildConcept(scheme, "ExternalIdentifier");
            this.addChildConcept(scheme, "ExternalLink");
            this.addChildConcept(scheme, "ExtrinsicObject");
            this.addChildConcept(scheme, "Organization");
            this.addChildConcept(scheme, "Package");
            this.addChildConcept(scheme, "Service");
            this.addChildConcept(scheme, "ServiceBinding");
            this.addChildConcept(scheme, "User");
        } else if ("PhoneType".equals(namePatterns)) {
            scheme = new ClassificationSchemeImpl((LifeCycleManager)this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:DB77450D-9FA8-45D4-A7BC-04411D14E384"));
            this.addChildConcept(scheme, "OfficePhone");
            this.addChildConcept(scheme, "HomePhone");
            this.addChildConcept(scheme, "MobilePhone");
            this.addChildConcept(scheme, "Beeper");
            this.addChildConcept(scheme, "FAX");
        } else if ("URLType".equals(namePatterns)) {
            scheme = new ClassificationSchemeImpl((LifeCycleManager)this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:DB77450D-9FA8-45D4-A7BC-04411D14E384"));
            this.addChildConcept(scheme, "HTTP");
            this.addChildConcept(scheme, "HTTPS");
            this.addChildConcept(scheme, "SMTP");
            this.addChildConcept(scheme, "PHONE");
            this.addChildConcept(scheme, "FAX");
            this.addChildConcept(scheme, "OTHER");
        } else if ("PostalAddressAttributes".equals(namePatterns)) {
            scheme = new ClassificationSchemeImpl((LifeCycleManager)this.registryService.getLifeCycleManagerImpl());
            scheme.setName(new InternationalStringImpl(namePatterns));
            scheme.setKey(new KeyImpl("UUID:DB77450D-9FA8-45D4-A7BC-04411D14E384"));
            this.addChildConcept(scheme, "StreetNumber");
            this.addChildConcept(scheme, "Street");
            this.addChildConcept(scheme, "City");
            this.addChildConcept(scheme, "State");
            this.addChildConcept(scheme, "PostalCode");
            this.addChildConcept(scheme, "Country");
        } else {
            IRegistry registry = (IRegistry)this.registryService.getRegistry();
            FindQualifiers juddiFindQualifiers = BusinessQueryManagerImpl.mapFindQualifiers(findQualifiers);
            try {
                TModelInfos infos;
                TModelList list = registry.findTModel(namePatterns, null, null, juddiFindQualifiers, 3);
                if (list != null && (infos = list.getTModelInfos()) != null) {
                    List<TModelInfo> tmodelInfoList = infos.getTModelInfo();
                    if (tmodelInfoList.size() > 1) {
                        throw new InvalidRequestException("Multiple matches found:" + tmodelInfoList.size());
                    }
                    if (tmodelInfoList.size() == 1) {
                        TModelInfo info = tmodelInfoList.get(0);
                        scheme = new ClassificationSchemeImpl((LifeCycleManager)this.registryService.getLifeCycleManagerImpl());
                        scheme.setName(new InternationalStringImpl(info.getName().getValue()));
                        scheme.setKey(new KeyImpl(info.getTModelKey()));
                    }
                }
            }
            catch (RegistryException e) {
                throw new JAXRException(e.getLocalizedMessage());
            }
        }
        return scheme;
    }

    private void addChildConcept(ClassificationSchemeImpl scheme, String name) throws JAXRException {
        ConceptImpl c = new ConceptImpl((LifeCycleManager)this.registryService.getLifeCycleManagerImpl());
        c.setName(new InternationalStringImpl(name));
        c.setValue(name);
        c.setScheme(scheme);
        scheme.addChildConcept(c);
    }

    public BulkResponse findClassificationSchemes(Collection findQualifiers, Collection namePatterns, Collection classifications, Collection externalLinks) throws JAXRException {
        ClassificationScheme classificationScheme;
        LinkedHashSet<ClassificationScheme> col = new LinkedHashSet<ClassificationScheme>();
        Iterator iter = namePatterns.iterator();
        String name = "";
        if (iter.hasNext()) {
            name = (String)iter.next();
        }
        if ((classificationScheme = this.findClassificationSchemeByName(findQualifiers, name)) != null) {
            col.add(classificationScheme);
        }
        return new BulkResponseImpl(col);
    }

    public Concept findConceptByPath(String path) throws JAXRException {
        return EnumerationHelper.getConceptByPath(path);
    }

    public BulkResponse findConcepts(Collection findQualifiers, Collection namePatterns, Collection classifications, Collection externalIdentifiers, Collection externalLinks) throws JAXRException {
        LinkedHashSet<Concept> col = new LinkedHashSet<Concept>();
        IRegistry registry = (IRegistry)this.registryService.getRegistry();
        FindQualifiers juddiFindQualifiers = BusinessQueryManagerImpl.mapFindQualifiers(findQualifiers);
        Iterator iter = null;
        if (namePatterns != null) {
            iter = namePatterns.iterator();
        }
        while (iter.hasNext()) {
            String namestr = (String)iter.next();
            try {
                List<TModelInfo> tmodelInfoList;
                TModelList list = registry.findTModel(namestr, ScoutJaxrUddiHelper.getCategoryBagFromClassifications(classifications), ScoutJaxrUddiHelper.getIdentifierBagFromExternalIdentifiers(externalIdentifiers), juddiFindQualifiers, 10);
                if (list == null || list.getTModelInfos() == null || (tmodelInfoList = list.getTModelInfos().getTModelInfo()) == null) continue;
                for (TModelInfo info : tmodelInfoList) {
                    col.add(ScoutUddiJaxrHelper.getConcept(info, (LifeCycleManager)this.registryService.getBusinessLifeCycleManager()));
                }
            }
            catch (RegistryException e) {
                throw new JAXRException(e.getLocalizedMessage());
            }
        }
        return new BulkResponseImpl(col);
    }

    public BulkResponse findRegistryPackages(Collection findQualifiers, Collection namePatterns, Collection classifications, Collection externalLinks) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public BulkResponse findServiceBindings(Key serviceKey, Collection findQualifiers, Collection classifications, Collection specifications) throws JAXRException {
        BulkResponseImpl blkRes = new BulkResponseImpl();
        IRegistry iRegistry = (IRegistry)this.registryService.getRegistry();
        FindQualifiers juddiFindQualifiers = BusinessQueryManagerImpl.mapFindQualifiers(findQualifiers);
        try {
            BindingDetail bindingDetail = iRegistry.findBinding(serviceKey.getId(), ScoutJaxrUddiHelper.getCategoryBagFromClassifications(classifications), ScoutJaxrUddiHelper.getTModelBagFromSpecifications(specifications), juddiFindQualifiers, this.registryService.getMaxRows());
            if (bindingDetail != null) {
                List<BindingTemplate> bindingTemplateList = bindingDetail.getBindingTemplate();
                BindingTemplate[] bindarr = new BindingTemplate[bindingTemplateList.size()];
                bindingTemplateList.toArray(bindarr);
                LinkedHashSet<ServiceBinding> col = new LinkedHashSet<ServiceBinding>();
                for (int i = 0; bindarr != null && i < bindarr.length; ++i) {
                    BindingTemplate si = bindarr[i];
                    ServiceBinding sb = ScoutUddiJaxrHelper.getServiceBinding(si, (LifeCycleManager)this.registryService.getBusinessLifeCycleManager());
                    col.add(sb);
                    Service s = (Service)this.getRegistryObject(serviceKey.getId(), "Service");
                    ((ServiceBindingImpl)sb).setService(s);
                }
                blkRes.setCollection(col);
            }
        }
        catch (RegistryException e) {
            throw new JAXRException(e.getLocalizedMessage());
        }
        return blkRes;
    }

    public BulkResponse findServices(Key orgKey, Collection findQualifiers, Collection namePatterns, Collection classifications, Collection specificationa) throws JAXRException {
        BulkResponseImpl blkRes = new BulkResponseImpl();
        IRegistry iRegistry = (IRegistry)this.registryService.getRegistry();
        FindQualifiers juddiFindQualifiers = BusinessQueryManagerImpl.mapFindQualifiers(findQualifiers);
        Name[] juddiNames = BusinessQueryManagerImpl.mapNamePatterns(namePatterns);
        try {
            ServiceList serviceList;
            String id = null;
            if (orgKey != null) {
                id = orgKey.getId();
            }
            if ((serviceList = iRegistry.findService(id, juddiNames, ScoutJaxrUddiHelper.getCategoryBagFromClassifications(classifications), null, juddiFindQualifiers, this.registryService.getMaxRows())) != null) {
                ServiceInfos serviceInfos = serviceList.getServiceInfos();
                LinkedHashSet<Service> col = new LinkedHashSet<Service>();
                if (serviceInfos != null && serviceInfos.getServiceInfo() != null) {
                    for (ServiceInfo si : serviceInfos.getServiceInfo()) {
                        Service srv = (Service)this.getRegistryObject(si.getServiceKey(), "Service");
                        col.add(srv);
                    }
                }
                blkRes.setCollection(col);
            }
        }
        catch (RegistryException e) {
            throw new JAXRException(e.getLocalizedMessage());
        }
        return blkRes;
    }

    public RegistryObject getRegistryObject(String id) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public RegistryObject getRegistryObject(String id, String objectType) throws JAXRException {
        IRegistry registry = (IRegistry)this.registryService.getRegistry();
        BusinessLifeCycleManager lcm = this.registryService.getBusinessLifeCycleManager();
        if ("ClassificationScheme".equalsIgnoreCase(objectType)) {
            try {
                TModelDetail tmodeldetail = registry.getTModelDetail(id);
                Concept c = ScoutUddiJaxrHelper.getConcept(tmodeldetail, (LifeCycleManager)lcm);
                ClassificationSchemeImpl scheme = new ClassificationSchemeImpl((LifeCycleManager)lcm);
                scheme.setName(c.getName());
                scheme.setDescription(c.getDescription());
                scheme.setKey(c.getKey());
                return scheme;
            }
            catch (RegistryException e) {
                throw new JAXRException(e.getLocalizedMessage());
            }
        }
        if ("Organization".equalsIgnoreCase(objectType)) {
            try {
                BusinessDetail orgdetail = registry.getBusinessDetail(id);
                return ScoutUddiJaxrHelper.getOrganization(orgdetail, (LifeCycleManager)lcm);
            }
            catch (RegistryException e) {
                throw new JAXRException(e.getLocalizedMessage());
            }
        }
        if ("Concept".equalsIgnoreCase(objectType)) {
            try {
                TModelDetail tmodeldetail = registry.getTModelDetail(id);
                return ScoutUddiJaxrHelper.getConcept(tmodeldetail, (LifeCycleManager)lcm);
            }
            catch (RegistryException e) {
                throw new JAXRException(e.getLocalizedMessage());
            }
        }
        if ("Service".equalsIgnoreCase(objectType)) {
            try {
                Iterator<BusinessService> i$;
                ServiceDetail sd = registry.getServiceDetail(id);
                if (sd != null && sd.getBusinessService() != null && (i$ = sd.getBusinessService().iterator()).hasNext()) {
                    BusinessService businessService = i$.next();
                    Service service = this.getServiceFromBusinessService(businessService, (LifeCycleManager)lcm);
                    return service;
                }
            }
            catch (RegistryException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    protected Service getServiceFromBusinessService(BusinessService bs, LifeCycleManager lcm) throws JAXRException {
        ServiceImpl service = (ServiceImpl)ScoutUddiJaxrHelper.getService(bs, lcm);
        service.setSubmittingOrganizationKey(bs.getBusinessKey());
        return service;
    }

    public BulkResponse getRegistryObjects() throws JAXRException {
        String[] types = new String[]{"Organization", "Service"};
        LinkedHashSet c = new LinkedHashSet();
        for (int i = 0; i < types.length; ++i) {
            try {
                BulkResponse bk = this.getRegistryObjects(types[i]);
                if (bk.getCollection() == null) continue;
                c.addAll(bk.getCollection());
                continue;
            }
            catch (JAXRException e) {
                this.log.debug((Object)("ignore - just a problem with that type? " + e.getMessage()), (Throwable)e);
            }
        }
        return new BulkResponseImpl(c);
    }

    public BulkResponse getRegistryObjects(Collection objectKeys) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BulkResponse getRegistryObjects(Collection objectKeys, String objectType) throws JAXRException {
        IRegistry registry = (IRegistry)this.registryService.getRegistry();
        String[] keys = new String[objectKeys.size()];
        int currLoc = 0;
        for (Key key : objectKeys) {
            keys[currLoc] = key.getId();
            ++currLoc;
        }
        LinkedHashSet<Object> col = new LinkedHashSet<Object>();
        BusinessLifeCycleManager lcm = this.registryService.getLifeCycleManagerImpl();
        if ("ClassificationScheme".equalsIgnoreCase(objectType)) {
            try {
                TModelDetail tmodeldetail = registry.getTModelDetail(keys);
                List<TModel> tmodelList = tmodeldetail.getTModel();
                for (TModel tModel : tmodelList) {
                    col.add(ScoutUddiJaxrHelper.getConcept(tModel, (LifeCycleManager)lcm));
                }
                return new BulkResponseImpl(col);
            }
            catch (RegistryException e) {
                throw new JAXRException(e.getLocalizedMessage());
            }
        }
        if ("Organization".equalsIgnoreCase(objectType)) {
            ConnectionImpl con = ((RegistryServiceImpl)this.getRegistryService()).getConnection();
            AuthToken auth = this.getAuthToken(con, registry);
            try {
                RegisteredInfo ri = null;
                try {
                    ri = registry.getRegisteredInfo(auth.getAuthInfo());
                }
                catch (RegistryException rve) {
                    String username = this.getUsernameFromCredentials(con.getCredentials());
                    if (AuthTokenSingleton.getToken(username) != null) {
                        AuthTokenSingleton.deleteAuthToken(username);
                    }
                    auth = this.getAuthToken(con, registry);
                    ri = registry.getRegisteredInfo(auth.getAuthInfo());
                }
                if (ri == null) return new BulkResponseImpl(col);
                for (String key : keys) {
                    BusinessDetail detail = registry.getBusinessDetail(key);
                    col.add(((BusinessLifeCycleManagerImpl)this.registryService.getLifeCycleManagerImpl()).createOrganization(detail));
                }
                return new BulkResponseImpl(col);
            }
            catch (RegistryException e) {
                throw new JAXRException(e.getLocalizedMessage());
            }
        }
        if ("Concept".equalsIgnoreCase(objectType)) {
            try {
                TModelDetail tmodeldetail = registry.getTModelDetail(keys);
                List<TModel> tmodelList = tmodeldetail.getTModel();
                for (TModel tmodel : tmodelList) {
                    col.add(ScoutUddiJaxrHelper.getConcept(tmodel, (LifeCycleManager)lcm));
                }
                return new BulkResponseImpl(col);
            }
            catch (RegistryException e) {
                throw new JAXRException(e.getLocalizedMessage());
            }
        }
        if (!"Service".equalsIgnoreCase(objectType)) throw new JAXRException("Unsupported type " + objectType + " for getRegistryObjects() in Apache Scout");
        try {
            ServiceDetail serviceDetail = registry.getServiceDetail(keys);
            if (serviceDetail == null) return new BulkResponseImpl(col);
            List<BusinessService> bizServiceList = serviceDetail.getBusinessService();
            for (BusinessService businessService : bizServiceList) {
                Service service = this.getServiceFromBusinessService(businessService, (LifeCycleManager)lcm);
                col.add(service);
            }
            return new BulkResponseImpl(col);
        }
        catch (RegistryException e) {
            throw new JAXRException((Throwable)e);
        }
    }

    public BulkResponse getRegistryObjects(String id) throws JAXRException {
        if ("Organization".equalsIgnoreCase(id)) {
            IRegistry registry = (IRegistry)this.registryService.getRegistry();
            ConnectionImpl con = ((RegistryServiceImpl)this.getRegistryService()).getConnection();
            AuthToken auth = this.getAuthToken(con, registry);
            LinkedHashSet<Organization> orgs = null;
            try {
                RegisteredInfo ri = null;
                try {
                    ri = registry.getRegisteredInfo(auth.getAuthInfo());
                }
                catch (RegistryException rve) {
                    String username = this.getUsernameFromCredentials(con.getCredentials());
                    if (AuthTokenSingleton.getToken(username) != null) {
                        AuthTokenSingleton.deleteAuthToken(username);
                    }
                    auth = this.getAuthToken(con, registry);
                    ri = registry.getRegisteredInfo(auth.getAuthInfo());
                }
                if (ri != null && ri.getBusinessInfos() != null) {
                    List<BusinessInfo> bizInfoList = ri.getBusinessInfos().getBusinessInfo();
                    orgs = new LinkedHashSet<Organization>();
                    for (BusinessInfo businessInfo : bizInfoList) {
                        BusinessDetail detail = registry.getBusinessDetail(businessInfo.getBusinessKey());
                        orgs.add(((BusinessLifeCycleManagerImpl)this.registryService.getLifeCycleManagerImpl()).createOrganization(detail));
                    }
                }
            }
            catch (RegistryException re) {
                throw new JAXRException((Throwable)re);
            }
            return new BulkResponseImpl(orgs);
        }
        if ("Service".equalsIgnoreCase(id)) {
            ArrayList<String> a = new ArrayList<String>();
            a.add("%");
            BulkResponse br = this.findServices(null, null, a, null, null);
            return br;
        }
        throw new JAXRException("Unsupported type for getRegistryObjects() :" + id);
    }

    static FindQualifiers mapFindQualifiers(Collection jaxrQualifiers) throws UnsupportedCapabilityException {
        if (jaxrQualifiers == null) {
            return null;
        }
        FindQualifiers result = objectFactory.createFindQualifiers();
        for (String jaxrQualifier : jaxrQualifiers) {
            String juddiQualifier = jaxrQualifier;
            if (juddiQualifier == null) {
                throw new UnsupportedCapabilityException("jUDDI does not support FindQualifer: " + jaxrQualifier);
            }
            result.getFindQualifier().add(juddiQualifier);
        }
        return result;
    }

    static Name[] mapNamePatterns(Collection namePatterns) throws JAXRException {
        if (namePatterns == null) {
            return null;
        }
        Name[] result = new Name[namePatterns.size()];
        int currLoc = 0;
        for (Object obj : namePatterns) {
            Name name = objectFactory.createName();
            if (obj instanceof String) {
                name.setValue((String)obj);
            } else if (obj instanceof LocalizedString) {
                LocalizedString ls = (LocalizedString)obj;
                name.setValue(ls.getValue());
                name.setLang(ls.getLocale().getLanguage());
            }
            result[currLoc] = name;
            ++currLoc;
        }
        return result;
    }

    private AuthToken getAuthToken(ConnectionImpl connection, IRegistry ireg) throws JAXRException {
        Set creds = connection.getCredentials();
        Iterator it = creds.iterator();
        String username = "";
        String pwd = "";
        while (it.hasNext()) {
            PasswordAuthentication pass = (PasswordAuthentication)it.next();
            username = pass.getUserName();
            pwd = new String(pass.getPassword());
        }
        if (AuthTokenSingleton.getToken(username) != null) {
            return AuthTokenSingleton.getToken(username);
        }
        AuthToken token = null;
        try {
            token = ireg.getAuthToken(username, pwd);
        }
        catch (Exception e) {
            throw new JAXRException((Throwable)e);
        }
        AuthTokenSingleton.addAuthToken(username, token);
        return token;
    }

    private String getUsernameFromCredentials(Set credentials) {
        String username = "";
        String pwd = "";
        if (credentials != null) {
            for (PasswordAuthentication pass : credentials) {
                username = pass.getUserName();
            }
        }
        return username;
    }
}

