/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.scout.registry;

import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.CapabilityProfile;
import javax.xml.registry.DeclarativeQueryManager;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.LifeCycleManager;
import javax.xml.registry.RegistryService;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.ClassificationScheme;
import org.apache.ws.scout.registry.BusinessLifeCycleManagerImpl;
import org.apache.ws.scout.registry.BusinessLifeCycleManagerV3Impl;
import org.apache.ws.scout.registry.BusinessQueryManagerImpl;
import org.apache.ws.scout.registry.BusinessQueryManagerV3Impl;
import org.apache.ws.scout.registry.CapabilityProfileImpl;
import org.apache.ws.scout.registry.ConnectionImpl;
import org.apache.ws.scout.registry.IRegistryBase;
import org.apache.ws.scout.registry.infomodel.ClassificationSchemeImpl;
import org.apache.ws.scout.registry.infomodel.KeyImpl;
import org.apache.ws.scout.transport.TransportException;

public class RegistryServiceImpl
implements RegistryService {
    private final IRegistryBase registry;
    private final BusinessQueryManager queryManager;
    private final BusinessLifeCycleManager lifeCycleManager;
    private final ClassificationSchemeImpl postalScheme;
    private final int maxRows;
    private final String uddiVersion;
    private ConnectionImpl connection;

    public RegistryServiceImpl(IRegistryBase registry, String postalScheme, int maxRows, String uddiVersion) {
        this.registry = registry;
        this.maxRows = maxRows;
        this.uddiVersion = uddiVersion;
        if ("3.0".equals(uddiVersion)) {
            this.queryManager = new BusinessQueryManagerV3Impl(this);
            this.lifeCycleManager = new BusinessLifeCycleManagerV3Impl(this);
        } else {
            this.queryManager = new BusinessQueryManagerImpl(this);
            this.lifeCycleManager = new BusinessLifeCycleManagerImpl(this);
        }
        if (postalScheme == null) {
            this.postalScheme = null;
        } else {
            this.postalScheme = new ClassificationSchemeImpl((LifeCycleManager)this.lifeCycleManager);
            this.postalScheme.setKey(new KeyImpl(postalScheme));
        }
    }

    IRegistryBase getRegistry() {
        return this.registry;
    }

    BusinessLifeCycleManager getLifeCycleManagerImpl() {
        return this.lifeCycleManager;
    }

    int getMaxRows() {
        return this.maxRows;
    }

    public CapabilityProfile getCapabilityProfile() {
        return new CapabilityProfileImpl();
    }

    public String getUddiVersion() {
        return this.uddiVersion;
    }

    public BusinessQueryManager getBusinessQueryManager() throws JAXRException {
        return this.queryManager;
    }

    public BusinessLifeCycleManager getBusinessLifeCycleManager() throws JAXRException {
        return this.lifeCycleManager;
    }

    public BulkResponse getBulkResponse(String s) throws JAXRException, InvalidRequestException {
        if (s == "" || s == null) {
            throw new InvalidRequestException();
        }
        return null;
    }

    public DeclarativeQueryManager getDeclarativeQueryManager() throws JAXRException, UnsupportedCapabilityException {
        throw new UnsupportedCapabilityException();
    }

    public ClassificationScheme getDefaultPostalScheme() throws JAXRException {
        return this.postalScheme;
    }

    public String makeRegistrySpecificRequest(String s) throws JAXRException {
        String inquiry = "INQUIRY";
        String publish = "PUBLISH";
        String type = "";
        String snippet = s.substring(0, 20);
        type = snippet.indexOf("save") > -1 ? publish : inquiry;
        try {
            return this.registry.execute(s, type);
        }
        catch (TransportException e) {
            throw new JAXRException(e.getLocalizedMessage());
        }
    }

    public ConnectionImpl getConnection() {
        return this.connection;
    }

    public void setConnection(ConnectionImpl connection) {
        this.connection = connection;
    }
}

