/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class NotificationInterceptor
extends CommandInterceptor {
    private CacheNotifier notifier;
    private static final Log log = LogFactory.getLog(NotificationInterceptor.class);

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void injectDependencies(CacheNotifier notifier) {
        this.notifier = notifier;
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, command);
        if (command.isOnePhaseCommit()) {
            this.notifier.notifyTransactionCompleted(ctx.getGlobalTransaction(), true, ctx);
        }
        return retval;
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, command);
        this.notifier.notifyTransactionCompleted(ctx.getGlobalTransaction(), true, ctx);
        return retval;
    }

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, command);
        this.notifier.notifyTransactionCompleted(ctx.getGlobalTransaction(), false, ctx);
        return retval;
    }
}

