/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.river;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.marshalling.MarshallerObjectInputStream;
import org.jboss.marshalling.TraceInformation;
import org.jboss.marshalling.reflect.SerializableField;
import org.jboss.marshalling.river.BlockUnmarshaller;
import org.jboss.marshalling.river.RiverUnmarshaller;
import org.jboss.marshalling.river.SerializableClassDescriptor;
import org.jboss.marshalling.util.BooleanReadField;
import org.jboss.marshalling.util.ByteReadField;
import org.jboss.marshalling.util.CharReadField;
import org.jboss.marshalling.util.DoubleReadField;
import org.jboss.marshalling.util.FloatReadField;
import org.jboss.marshalling.util.IntReadField;
import org.jboss.marshalling.util.LongReadField;
import org.jboss.marshalling.util.ObjectReadField;
import org.jboss.marshalling.util.ReadField;
import org.jboss.marshalling.util.ShortReadField;

public class RiverObjectInputStream
extends MarshallerObjectInputStream {
    private AtomicReference<State> state = new AtomicReference<State>(State.OFF);
    private final RiverUnmarshaller unmarshaller;
    private final BlockUnmarshaller blockUnmarshaller;
    private SerializableClassDescriptor serializableClassDescriptor;
    private Object current;
    private int restoreIdx;

    protected RiverObjectInputStream(RiverUnmarshaller riverUnmarshaller, BlockUnmarshaller delegateUnmarshaller) throws IOException, SecurityException {
        super(delegateUnmarshaller);
        this.unmarshaller = riverUnmarshaller;
        this.blockUnmarshaller = delegateUnmarshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void defaultReadObject() throws IOException, ClassNotFoundException {
        State old = this.state.getAndSet(State.ON);
        switch (old) {
            case UNREAD_FIELDS: 
            case UNREAD_FIELDS_EOB: {
                break;
            }
            default: {
                throw new NotActiveException("readFields() may only be called when the fields have not yet been read");
            }
        }
        try {
            this.unmarshaller.readFields(this.current, this.serializableClassDescriptor);
            if (old == State.UNREAD_FIELDS_EOB) {
                this.restoreIdx = this.blockUnmarshaller.tempEndOfStream();
            }
        }
        finally {
            this.serializableClassDescriptor = null;
            this.current = null;
        }
    }

    @Override
    public ObjectInputStream.GetField readFields() throws IOException, ClassNotFoundException {
        State old = this.state.getAndSet(State.ON);
        switch (old) {
            case UNREAD_FIELDS: 
            case UNREAD_FIELDS_EOB: {
                break;
            }
            default: {
                throw new NotActiveException("readFields() may only be called when the fields have not yet been read");
            }
        }
        SerializableField[] streamFields = this.serializableClassDescriptor.getFields();
        int cnt = streamFields.length;
        final ReadField[] readFields = new ReadField[cnt];
        for (int i = 0; i < cnt; ++i) {
            SerializableField field = streamFields[i];
            try {
                switch (field.getKind()) {
                    case BOOLEAN: {
                        readFields[i] = new BooleanReadField(field, this.unmarshaller.readBoolean());
                        break;
                    }
                    case BYTE: {
                        readFields[i] = new ByteReadField(field, this.unmarshaller.readByte());
                        break;
                    }
                    case CHAR: {
                        readFields[i] = new CharReadField(field, this.unmarshaller.readChar());
                        break;
                    }
                    case DOUBLE: {
                        readFields[i] = new DoubleReadField(field, this.unmarshaller.readDouble());
                        break;
                    }
                    case FLOAT: {
                        readFields[i] = new FloatReadField(field, this.unmarshaller.readFloat());
                        break;
                    }
                    case INT: {
                        readFields[i] = new IntReadField(field, this.unmarshaller.readInt());
                        break;
                    }
                    case LONG: {
                        readFields[i] = new LongReadField(field, this.unmarshaller.readLong());
                        break;
                    }
                    case OBJECT: {
                        readFields[i] = new ObjectReadField(field, this.unmarshaller.readObject());
                        break;
                    }
                    case SHORT: {
                        readFields[i] = new ShortReadField(field, this.unmarshaller.readShort());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Wrong field type");
                    }
                }
                continue;
            }
            catch (IOException e) {
                TraceInformation.addFieldInformation(e, field.getName());
                throw e;
            }
            catch (ClassNotFoundException e) {
                TraceInformation.addFieldInformation(e, field.getName());
                throw e;
            }
            catch (RuntimeException e) {
                TraceInformation.addFieldInformation(e, field.getName());
                throw e;
            }
        }
        if (old == State.UNREAD_FIELDS_EOB) {
            this.restoreIdx = this.blockUnmarshaller.tempEndOfStream();
        }
        return new ObjectInputStream.GetField(){

            @Override
            public ObjectStreamClass getObjectStreamClass() {
                throw new UnsupportedOperationException("TODO...");
            }

            private ReadField find(String name) {
                if (name == null) {
                    throw new NullPointerException("name is null");
                }
                for (ReadField field : readFields) {
                    if (!name.equals(field.getName())) continue;
                    return field;
                }
                throw new IllegalArgumentException("No field named '" + name + "'");
            }

            @Override
            public boolean defaulted(String name) throws IOException {
                return this.find(name).isDefaulted();
            }

            @Override
            public boolean get(String name, boolean val) throws IOException {
                ReadField field = this.find(name);
                return field.isDefaulted() ? val : field.getBoolean();
            }

            @Override
            public byte get(String name, byte val) throws IOException {
                ReadField field = this.find(name);
                return field.isDefaulted() ? val : field.getByte();
            }

            @Override
            public char get(String name, char val) throws IOException {
                ReadField field = this.find(name);
                return field.isDefaulted() ? val : field.getChar();
            }

            @Override
            public short get(String name, short val) throws IOException {
                ReadField field = this.find(name);
                return field.isDefaulted() ? val : field.getShort();
            }

            @Override
            public int get(String name, int val) throws IOException {
                ReadField field = this.find(name);
                return field.isDefaulted() ? val : field.getInt();
            }

            @Override
            public long get(String name, long val) throws IOException {
                ReadField field = this.find(name);
                return field.isDefaulted() ? val : field.getLong();
            }

            @Override
            public float get(String name, float val) throws IOException {
                ReadField field = this.find(name);
                return field.isDefaulted() ? val : field.getFloat();
            }

            @Override
            public double get(String name, double val) throws IOException {
                ReadField field = this.find(name);
                return field.isDefaulted() ? val : field.getDouble();
            }

            @Override
            public Object get(String name, Object val) throws IOException {
                ReadField field = this.find(name);
                return field.isDefaulted() ? val : field.getObject();
            }
        };
    }

    @Override
    public void registerValidation(ObjectInputValidation obj, int prio) throws NotActiveException, InvalidObjectException {
        this.unmarshaller.addValidation(obj, prio);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SerializableClassDescriptor swapClass(SerializableClassDescriptor descriptor) {
        try {
            SerializableClassDescriptor serializableClassDescriptor = this.serializableClassDescriptor;
            return serializableClassDescriptor;
        }
        finally {
            this.serializableClassDescriptor = descriptor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object swapCurrent(Object obj) {
        try {
            Object object = this.current;
            return object;
        }
        finally {
            this.current = obj;
        }
    }

    protected State start() {
        return this.state.getAndSet(State.UNREAD_FIELDS);
    }

    protected void finish(State restoreState) throws IOException {
        switch (this.state.getAndSet(restoreState)) {
            case OFF: {
                break;
            }
            case ON: {
                break;
            }
            case UNREAD_FIELDS: {
                if (this.serializableClassDescriptor.getFields().length <= 0) break;
                throw new NotActiveException("Fields were never read");
            }
        }
    }

    protected void fullReset() {
        this.state.set(State.OFF);
        this.serializableClassDescriptor = null;
        this.current = null;
    }

    protected void noCustomData() {
        this.state.set(State.UNREAD_FIELDS_EOB);
    }

    protected int getRestoreIdx() {
        return this.restoreIdx;
    }

    protected static enum State {
        OFF,
        UNREAD_FIELDS,
        UNREAD_FIELDS_EOB,
        ON;

    }
}

