/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.builder.runtime;

import java.util.Collection;
import javax.xml.namespace.QName;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.xb.builder.runtime.AbstractPropertyHandler;
import org.jboss.xb.builder.runtime.BuilderUtil;
import org.jboss.xb.spi.BeanAdapter;
import org.jboss.xb.util.CollectionFactory;

public class CollectionPropertyHandler
extends AbstractPropertyHandler {
    private final CollectionFactory colFactory;
    private TypeInfo componentType;

    public CollectionPropertyHandler(PropertyInfo propertyInfo, TypeInfo propertyType) {
        super(propertyInfo, propertyType);
        this.componentType = ((ClassInfo)propertyType).getComponentType();
        this.colFactory = CollectionFactory.getFactory((ClassInfo)propertyType);
    }

    public void handle(PropertyInfo propertyInfo, TypeInfo propertyType, Object parent, Object child, QName qName) {
        if (this.componentType != null && child != null && !this.componentType.isInstance(child)) {
            throw new IllegalArgumentException("Child is not an instance of " + this.componentType + ", child: " + child);
        }
        BeanAdapter beanAdapter = (BeanAdapter)parent;
        Collection<Object> c = null;
        try {
            if (propertyInfo.getGetter() != null) {
                c = (Collection<Object>)beanAdapter.get(propertyInfo);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("QName " + qName + " error getting collection property " + propertyInfo.getName() + " for " + BuilderUtil.toDebugString(parent), t);
        }
        if (c == null) {
            try {
                c = this.colFactory.createCollection();
            }
            catch (Throwable t) {
                throw new RuntimeException("QName " + qName + " error creating collection: " + propertyType.getName(), t);
            }
            try {
                beanAdapter.set(propertyInfo, c);
            }
            catch (Throwable t) {
                throw new RuntimeException("QName " + qName + " error setting collection property " + propertyInfo.getName() + " for " + BuilderUtil.toDebugString(parent) + " with value " + BuilderUtil.toDebugString(c), t);
            }
        }
        c.add(child);
    }
}

