/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming;

import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.jboss.as.naming.JndiPermission;
import org.jboss.as.naming.NamingMessages;

final class JndiPermissionCollection
extends PermissionCollection
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<JndiPermission> perms = new ArrayList<JndiPermission>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Permission permission) {
        if (!(permission instanceof JndiPermission)) {
            throw NamingMessages.MESSAGES.invalidPermission(permission);
        }
        if (this.isReadOnly()) {
            throw NamingMessages.MESSAGES.cannotAddToReadOnlyPermissionCollection();
        }
        JndiPermissionCollection jndiPermissionCollection = this;
        synchronized (jndiPermissionCollection) {
            this.perms.add((JndiPermission)permission);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof JndiPermission)) {
            return false;
        }
        JndiPermission fp = (JndiPermission)permission;
        int desired = fp.getMask();
        int effective = 0;
        int needed = desired;
        JndiPermissionCollection jndiPermissionCollection = this;
        synchronized (jndiPermissionCollection) {
            for (JndiPermission x : this.perms) {
                if ((needed & x.getMask()) == 0 || !x.impliesIgnoreMask(fp)) continue;
                if (((effective |= x.getMask()) & desired) == desired) {
                    return true;
                }
                needed = desired ^ effective;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration elements() {
        JndiPermissionCollection jndiPermissionCollection = this;
        synchronized (jndiPermissionCollection) {
            return Collections.enumeration(this.perms);
        }
    }
}

