/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.mdr;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.jca.common.api.metadata.ironjacamar.IronJacamar;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.core.CoreBundle;
import org.jboss.jca.core.spi.mdr.AlreadyExistsException;
import org.jboss.jca.core.spi.mdr.MetadataRepository;
import org.jboss.jca.core.spi.mdr.NotFoundException;
import org.jboss.logging.Messages;

public class SimpleMetadataRepository
implements MetadataRepository {
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);
    private ConcurrentMap<String, Connector> raTemplates = new ConcurrentHashMap<String, Connector>();
    private ConcurrentMap<String, File> raRoots = new ConcurrentHashMap<String, File>();
    private Map<String, IronJacamar> ironJacamar = new HashMap<String, IronJacamar>();
    private ConcurrentMap<String, Map<String, List<String>>> jndiMappings = new ConcurrentHashMap<String, Map<String, List<String>>>();

    public void registerResourceAdapter(String uniqueId, File root, Connector md, IronJacamar ijmd) throws AlreadyExistsException {
        if (uniqueId == null) {
            throw new IllegalArgumentException("UniqueId is null");
        }
        if (uniqueId.trim().equals("")) {
            throw new IllegalArgumentException("UniqueId is empty");
        }
        if (root == null) {
            throw new IllegalArgumentException("Root is null");
        }
        if (md == null) {
            throw new IllegalArgumentException("Connector is null");
        }
        if (this.raTemplates.containsKey(uniqueId)) {
            throw new AlreadyExistsException(bundle.keyNotRegistered(uniqueId));
        }
        this.raTemplates.put(uniqueId, md);
        this.raRoots.put(uniqueId, root);
        this.ironJacamar.put(uniqueId, ijmd);
    }

    public void unregisterResourceAdapter(String uniqueId) throws NotFoundException {
        if (uniqueId == null) {
            throw new IllegalArgumentException("UniqueId is null");
        }
        if (uniqueId.trim().equals("")) {
            throw new IllegalArgumentException("UniqueId is empty");
        }
        if (!this.raTemplates.containsKey(uniqueId)) {
            throw new NotFoundException(bundle.keyNotRegistered(uniqueId));
        }
        this.raTemplates.remove(uniqueId);
        this.raRoots.remove(uniqueId);
        this.ironJacamar.remove(uniqueId);
    }

    public boolean hasResourceAdapter(String uniqueId) {
        if (uniqueId == null) {
            throw new IllegalArgumentException("UniqueId is null");
        }
        if (uniqueId.trim().equals("")) {
            throw new IllegalArgumentException("UniqueId is empty");
        }
        return this.raTemplates.containsKey(uniqueId);
    }

    public Connector getResourceAdapter(String uniqueId) throws NotFoundException {
        if (uniqueId == null) {
            throw new IllegalArgumentException("UniqueId is null");
        }
        if (uniqueId.trim().equals("")) {
            throw new IllegalArgumentException("UniqueId is empty");
        }
        if (!this.raTemplates.containsKey(uniqueId)) {
            throw new NotFoundException(bundle.keyNotRegistered(uniqueId));
        }
        Connector md = (Connector)this.raTemplates.get(uniqueId);
        return (Connector)md.copy();
    }

    public Set<String> getResourceAdapters() {
        return Collections.unmodifiableSet(this.raTemplates.keySet());
    }

    public File getRoot(String uniqueId) throws NotFoundException {
        if (uniqueId == null) {
            throw new IllegalArgumentException("UniqueId is null");
        }
        if (uniqueId.trim().equals("")) {
            throw new IllegalArgumentException("UniqueId is empty");
        }
        if (!this.raRoots.containsKey(uniqueId)) {
            throw new NotFoundException(bundle.keyNotRegistered(uniqueId));
        }
        return (File)this.raRoots.get(uniqueId);
    }

    public IronJacamar getIronJacamar(String uniqueId) throws NotFoundException {
        if (uniqueId == null) {
            throw new IllegalArgumentException("UniqueId is null");
        }
        if (uniqueId.trim().equals("")) {
            throw new IllegalArgumentException("UniqueId is empty");
        }
        if (!this.ironJacamar.containsKey(uniqueId)) {
            throw new NotFoundException(bundle.keyNotRegistered(uniqueId));
        }
        return this.ironJacamar.get(uniqueId);
    }

    public void registerJndiMapping(String uniqueId, String clz, String jndi) {
        ArrayList<String> l;
        HashMap newMappings;
        if (uniqueId == null) {
            throw new IllegalArgumentException("UniqueId is null");
        }
        if (uniqueId.trim().equals("")) {
            throw new IllegalArgumentException("UniqueId is empty");
        }
        if (clz == null) {
            throw new IllegalArgumentException("Clz is null");
        }
        if (clz.trim().equals("")) {
            throw new IllegalArgumentException("Clz is empty");
        }
        if (jndi == null) {
            throw new IllegalArgumentException("Jndi is null");
        }
        if (jndi.trim().equals("")) {
            throw new IllegalArgumentException("Jndi is empty");
        }
        HashMap mappings = (HashMap)this.jndiMappings.get(uniqueId);
        if (mappings == null && (mappings = (Map)this.jndiMappings.putIfAbsent(uniqueId, newMappings = new HashMap(1))) == null) {
            mappings = newMappings;
        }
        if ((l = (ArrayList<String>)mappings.get(clz)) == null) {
            l = new ArrayList<String>(1);
        }
        l.add(jndi);
        mappings.put(clz, l);
    }

    public void unregisterJndiMapping(String uniqueId, String clz, String jndi) throws NotFoundException {
        if (uniqueId == null) {
            throw new IllegalArgumentException("UniqueId is null");
        }
        if (uniqueId.trim().equals("")) {
            throw new IllegalArgumentException("Uniqueid is empty");
        }
        if (clz == null) {
            throw new IllegalArgumentException("Clz is null");
        }
        if (clz.trim().equals("")) {
            throw new IllegalArgumentException("Clz is empty");
        }
        if (jndi == null) {
            throw new IllegalArgumentException("Jndi is null");
        }
        if (jndi.trim().equals("")) {
            throw new IllegalArgumentException("Jndi is empty");
        }
        if (!this.jndiMappings.containsKey(uniqueId)) {
            throw new NotFoundException(bundle.keyNotRegistered(uniqueId));
        }
        Map mappings = (Map)this.jndiMappings.get(uniqueId);
        if (mappings != null) {
            List l = (List)mappings.get(clz);
            if (l != null) {
                l.remove(jndi);
                if (l.size() == 0) {
                    mappings.remove(clz);
                }
            }
            if (mappings.size() == 0) {
                this.jndiMappings.remove(uniqueId);
            }
        }
    }

    public boolean hasJndiMappings(String uniqueId) {
        if (uniqueId == null) {
            throw new IllegalArgumentException("UniqueId is null");
        }
        if (uniqueId.trim().equals("")) {
            throw new IllegalArgumentException("UniqueId is empty");
        }
        return this.jndiMappings.containsKey(uniqueId);
    }

    public Map<String, List<String>> getJndiMappings(String uniqueId) throws NotFoundException {
        if (uniqueId == null) {
            throw new IllegalArgumentException("UniqueId is null");
        }
        if (uniqueId.trim().equals("")) {
            throw new IllegalArgumentException("UniqueId is empty");
        }
        if (!this.jndiMappings.containsKey(uniqueId)) {
            throw new NotFoundException(bundle.keyNotRegistered(uniqueId));
        }
        Map mappings = (Map)this.jndiMappings.get(uniqueId);
        if (mappings == null) {
            return Collections.unmodifiableMap(new HashMap(0));
        }
        return Collections.unmodifiableMap(mappings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SimpleMetadataRepository@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[");
        sb.append(" raTemplates=").append(this.raTemplates);
        sb.append(" raRoots=").append(this.raRoots);
        sb.append(" ironJacamar=").append(this.ironJacamar);
        sb.append(" jndiMappings=").append(this.jndiMappings);
        sb.append("]");
        return sb.toString();
    }
}

