/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.entity.entitycache;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ejb.NoSuchEJBException;
import javax.transaction.Synchronization;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.as.ejb3.component.entity.EntityBeanComponent;
import org.jboss.as.ejb3.component.entity.EntityBeanComponentInstance;
import org.jboss.as.ejb3.component.entity.entitycache.ReadyEntityCache;

public class TransactionLocalEntityCache
implements ReadyEntityCache {
    private final TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    private final ConcurrentMap<Object, Map<Object, CacheEntry>> cache = new ConcurrentHashMap<Object, Map<Object, CacheEntry>>(Runtime.getRuntime().availableProcessors());
    private final EntityBeanComponent component;

    public TransactionLocalEntityCache(EntityBeanComponent component) {
        this.component = component;
        this.transactionSynchronizationRegistry = component.getTransactionSynchronizationRegistry();
    }

    @Override
    public EntityBeanComponentInstance get(Object key) throws NoSuchEJBException {
        if (!this.isTransactionActive()) {
            return this.createInstance(key);
        }
        Map<Object, CacheEntry> cache = this.prepareCache();
        if (!cache.containsKey(key)) {
            EntityBeanComponentInstance instance = this.createInstance(key);
            this.realCreate(instance, false);
        }
        CacheEntry cacheEntry = cache.get(key);
        cacheEntry.referenceCount.incrementAndGet();
        return cacheEntry.instance;
    }

    @Override
    public void discard(EntityBeanComponentInstance instance) {
        Object key;
        Map map;
        if (this.isTransactionActive() && (map = (Map)this.cache.get(key = this.transactionSynchronizationRegistry.getTransactionKey())) != null) {
            map.remove(instance.getPrimaryKey());
        }
    }

    @Override
    public void create(EntityBeanComponentInstance instance) throws NoSuchEJBException {
        this.realCreate(instance, true);
    }

    private void realCreate(EntityBeanComponentInstance instance, boolean incRefCount) throws NoSuchEJBException {
        if (this.isTransactionActive()) {
            Map<Object, CacheEntry> map = this.prepareCache();
            CacheEntry cacheEntry = new CacheEntry(instance);
            map.put(instance.getPrimaryKey(), cacheEntry);
            if (incRefCount) {
                cacheEntry.referenceCount.incrementAndGet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(EntityBeanComponentInstance instance, boolean success) {
        Object key;
        if (instance.isDiscarded()) {
            return;
        }
        if (instance.getPrimaryKey() == null) {
            return;
        }
        if (!success && instance.isRemoved()) {
            instance.setRemoved(false);
        }
        if ((key = this.transactionSynchronizationRegistry.getTransactionKey()) == null) {
            instance.passivate();
            this.component.releaseEntityBeanInstance(instance);
            return;
        }
        Map map = (Map)this.cache.get(key);
        if (map != null) {
            CacheEntry cacheEntry = (CacheEntry)map.get(instance.getPrimaryKey());
            if (cacheEntry == null) {
                throw new IllegalArgumentException("Instance [" + (Object)((Object)instance) + "] not found in cache");
            }
            if (cacheEntry.referenceCount.decrementAndGet() <= 0) {
                Object pk = instance.getPrimaryKey();
                try {
                    instance.passivate();
                    this.component.releaseEntityBeanInstance(instance);
                }
                finally {
                    map.remove(pk);
                }
            }
        }
    }

    public void reference(EntityBeanComponentInstance instance) {
        Map<Object, CacheEntry> cache = this.prepareCache();
        CacheEntry cacheEntry = cache.get(instance.getPrimaryKey());
        if (cacheEntry == null) {
            throw new IllegalArgumentException("Instance [" + (Object)((Object)instance) + "] not found in cache");
        }
        cacheEntry.referenceCount.incrementAndGet();
    }

    @Override
    public synchronized void start() {
    }

    @Override
    public synchronized void stop() {
    }

    private Map<Object, CacheEntry> prepareCache() {
        final Object key = this.transactionSynchronizationRegistry.getTransactionKey();
        Map<Object, CacheEntry> map = (Map<Object, CacheEntry>)this.cache.get(key);
        if (map != null) {
            return map;
        }
        map = Collections.synchronizedMap(new HashMap());
        Map existing = this.cache.putIfAbsent(key, map);
        if (existing != null) {
            map = existing;
        }
        this.transactionSynchronizationRegistry.registerInterposedSynchronization(new Synchronization(){

            public void beforeCompletion() {
            }

            public void afterCompletion(int status) {
                TransactionLocalEntityCache.this.cache.remove(key);
            }
        });
        return map;
    }

    private EntityBeanComponentInstance createInstance(Object pk) {
        EntityBeanComponentInstance instance = this.component.acquireUnAssociatedInstance();
        instance.associate(pk);
        return instance;
    }

    private boolean isTransactionActive() {
        return this.transactionSynchronizationRegistry.getTransactionKey() != null;
    }

    private class CacheEntry {
        private final AtomicInteger referenceCount = new AtomicInteger(0);
        private final EntityBeanComponentInstance instance;

        private CacheEntry(EntityBeanComponentInstance instance) {
            this.instance = instance;
        }
    }
}

