/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote.protocol.versionone;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import org.jboss.as.ejb3.remote.EJBRemoteTransactionsRepository;
import org.jboss.as.ejb3.remote.protocol.versionone.AbstractMessageHandler;
import org.jboss.as.ejb3.remote.protocol.versionone.UserTransactionCommitTask;
import org.jboss.as.ejb3.remote.protocol.versionone.UserTransactionManagementTask;
import org.jboss.as.ejb3.remote.protocol.versionone.UserTransactionRollbackTask;
import org.jboss.as.ejb3.remote.protocol.versionone.XidTransactionBeforeCompletionTask;
import org.jboss.as.ejb3.remote.protocol.versionone.XidTransactionCommitTask;
import org.jboss.as.ejb3.remote.protocol.versionone.XidTransactionForgetTask;
import org.jboss.as.ejb3.remote.protocol.versionone.XidTransactionManagementTask;
import org.jboss.as.ejb3.remote.protocol.versionone.XidTransactionPrepareTask;
import org.jboss.as.ejb3.remote.protocol.versionone.XidTransactionRollbackTask;
import org.jboss.ejb.client.TransactionID;
import org.jboss.ejb.client.UserTransactionID;
import org.jboss.ejb.client.XidTransactionID;
import org.jboss.ejb.client.remoting.PackedInteger;
import org.jboss.logging.Logger;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.MessageInputStream;

class TransactionRequestHandler
extends AbstractMessageHandler {
    private static final Logger logger = Logger.getLogger(TransactionRequestHandler.class);
    private static final byte HEADER_TX_INVOCATION_RESPONSE = 20;
    private final ExecutorService executorService;
    private final EJBRemoteTransactionsRepository transactionsRepository;
    private final TransactionRequestType txRequestType;
    private final MarshallerFactory marshallerFactory;

    TransactionRequestHandler(EJBRemoteTransactionsRepository transactionsRepository, MarshallerFactory marshallerFactory, ExecutorService executorService, TransactionRequestType txRequestType) {
        this.executorService = executorService;
        this.transactionsRepository = transactionsRepository;
        this.txRequestType = txRequestType;
        this.marshallerFactory = marshallerFactory;
    }

    @Override
    public void processMessage(Channel channel, MessageInputStream messageInputStream) throws IOException {
        DataInputStream input = new DataInputStream((InputStream)messageInputStream);
        short invocationId = input.readShort();
        int transactionIDBytesLength = PackedInteger.readPackedInteger((DataInput)input);
        byte[] transactionIDBytes = new byte[transactionIDBytesLength];
        input.read(transactionIDBytes);
        TransactionID transactionID = TransactionID.createTransactionID((byte[])transactionIDBytes);
        boolean onePhaseCommit = false;
        if (this.txRequestType == TransactionRequestType.COMMIT) {
            onePhaseCommit = input.readBoolean();
        }
        if (transactionID instanceof UserTransactionID) {
            UserTransactionManagementTask userTransactionManagementTask;
            switch (this.txRequestType) {
                case COMMIT: {
                    userTransactionManagementTask = new UserTransactionCommitTask(this, this.transactionsRepository, this.marshallerFactory, (UserTransactionID)transactionID, channel, invocationId);
                    break;
                }
                case ROLLBACK: {
                    userTransactionManagementTask = new UserTransactionRollbackTask(this, this.transactionsRepository, this.marshallerFactory, (UserTransactionID)transactionID, channel, invocationId);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown transaction request type " + (Object)((Object)this.txRequestType));
                }
            }
            this.executorService.submit(userTransactionManagementTask);
        } else if (transactionID instanceof XidTransactionID) {
            XidTransactionManagementTask xidTransactionManagementTask;
            XidTransactionID xidTransactionID = (XidTransactionID)transactionID;
            switch (this.txRequestType) {
                case COMMIT: {
                    xidTransactionManagementTask = new XidTransactionCommitTask(this, this.transactionsRepository, this.marshallerFactory, xidTransactionID, channel, invocationId, onePhaseCommit);
                    break;
                }
                case PREPARE: {
                    xidTransactionManagementTask = new XidTransactionPrepareTask(this, this.transactionsRepository, this.marshallerFactory, xidTransactionID, channel, invocationId);
                    break;
                }
                case ROLLBACK: {
                    xidTransactionManagementTask = new XidTransactionRollbackTask(this, this.transactionsRepository, this.marshallerFactory, xidTransactionID, channel, invocationId);
                    break;
                }
                case FORGET: {
                    xidTransactionManagementTask = new XidTransactionForgetTask(this, this.transactionsRepository, this.marshallerFactory, xidTransactionID, channel, invocationId);
                    break;
                }
                case BEFORE_COMPLETION: {
                    xidTransactionManagementTask = new XidTransactionBeforeCompletionTask(this, this.transactionsRepository, this.marshallerFactory, xidTransactionID, channel, invocationId);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown transaction request type " + (Object)((Object)this.txRequestType));
                }
            }
            this.executorService.submit(xidTransactionManagementTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeTxPrepareResponseMessage(Channel channel, short invocationId, int xaResourceStatusCode) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)channel.writeMessage());
        try {
            dataOutputStream.writeByte(20);
            dataOutputStream.writeShort(invocationId);
            dataOutputStream.writeBoolean(true);
            PackedInteger.writePackedInteger((DataOutput)dataOutputStream, (int)xaResourceStatusCode);
        }
        finally {
            dataOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeTxInvocationResponseMessage(Channel channel, short invocationId) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)channel.writeMessage());
        try {
            dataOutputStream.writeByte(20);
            dataOutputStream.writeShort(invocationId);
            dataOutputStream.writeBoolean(false);
        }
        finally {
            dataOutputStream.close();
        }
    }

    static enum TransactionRequestType {
        COMMIT,
        ROLLBACK,
        PREPARE,
        FORGET,
        BEFORE_COMPLETION;

    }
}

