/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.List;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.deployment.processors.EjbIIOPDeploymentUnitProcessor;
import org.jboss.as.ejb3.subsystem.EJB3IIOPResourceDefinition;
import org.jboss.as.ejb3.subsystem.IIOPSettingsService;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;

public class EJB3IIOPAdd
extends AbstractBoottimeAddStepHandler {
    static final EJB3IIOPAdd INSTANCE = new EJB3IIOPAdd();

    private EJB3IIOPAdd() {
    }

    static ModelNode create(boolean enableByDefault, boolean useQualifiedName) {
        ModelNode address = new ModelNode();
        address.add("subsystem", "ejb3");
        address.add("service", "iiop");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        operation.get("address").set(address);
        operation.get("enable-by-default").set(enableByDefault);
        operation.get("use-qualified-name").set(useQualifiedName);
        return operation;
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        Boolean enableByDefault = EJB3IIOPResourceDefinition.ENABLE_BY_DEFAULT.resolveModelAttribute(context, model).asBoolean();
        Boolean useQualifiedName = EJB3IIOPResourceDefinition.USE_QUALIFIED_NAME.resolveModelAttribute(context, model).asBoolean();
        final IIOPSettingsService settingsService = new IIOPSettingsService(enableByDefault, useQualifiedName);
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                EjbLogger.ROOT_LOGGER.debug("Adding EJB IIOP support");
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, 9728, (DeploymentUnitProcessor)new EjbIIOPDeploymentUnitProcessor(settingsService));
            }
        }, OperationContext.Stage.RUNTIME);
        newControllers.add(context.getServiceTarget().addService(IIOPSettingsService.SERVICE_NAME, (Service)settingsService).install());
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        model.get("enable-by-default").set(operation.require("enable-by-default").asString());
        model.get("use-qualified-name").set(operation.require("use-qualified-name").asString());
    }
}

