/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import org.jboss.as.connector.ConnectorMessages;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.connector.registry.DriverRegistry;
import org.jboss.as.connector.registry.InstalledDriver;
import org.jboss.as.connector.subsystems.datasources.Constants;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class InstalledDriversListOperationHandler
implements OperationStepHandler {
    public static final InstalledDriversListOperationHandler INSTANCE = new InstalledDriversListOperationHandler();

    private InstalledDriversListOperationHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.isNormalServer()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceController sc = context.getServiceRegistry(false).getRequiredService(ConnectorServices.JDBC_DRIVER_REGISTRY_SERVICE);
                    DriverRegistry driverRegistry = (DriverRegistry)DriverRegistry.class.cast(sc.getValue());
                    ModelNode result = context.getResult();
                    for (InstalledDriver driver : driverRegistry.getInstalledDrivers()) {
                        ModelNode driverNode = new ModelNode();
                        driverNode.get(Constants.DRIVER_NAME.getName()).set(driver.getDriverName());
                        if (driver.isFromDeployment()) {
                            driverNode.get("deployment-name").set(driver.getDriverName());
                            driverNode.get(Constants.DRIVER_MODULE_NAME.getName());
                            driverNode.get("module-slot");
                            driverNode.get(Constants.DRIVER_DATASOURCE_CLASS_NAME.getName());
                            driverNode.get(Constants.DRIVER_XA_DATASOURCE_CLASS_NAME.getName());
                        } else {
                            driverNode.get("deployment-name");
                            driverNode.get(Constants.DRIVER_MODULE_NAME.getName()).set(driver.getModuleName().getName());
                            driverNode.get("module-slot").set(driver.getModuleName() != null ? driver.getModuleName().getSlot() : "");
                            driverNode.get(Constants.DRIVER_DATASOURCE_CLASS_NAME.getName()).set(driver.getDataSourceClassName() != null ? driver.getDataSourceClassName() : "");
                            driverNode.get(Constants.DRIVER_XA_DATASOURCE_CLASS_NAME.getName()).set(driver.getXaDataSourceClassName() != null ? driver.getXaDataSourceClassName() : "");
                        }
                        driverNode.get(Constants.DRIVER_CLASS_NAME.getName()).set(driver.getDriverClassName());
                        driverNode.get(Constants.DRIVER_MAJOR_VERSION.getName()).set(driver.getMajorVersion());
                        driverNode.get(Constants.DRIVER_MINOR_VERSION.getName()).set(driver.getMinorVersion());
                        driverNode.get("jdbc-compliant").set(driver.isJdbcCompliant());
                        result.add(driverNode);
                    }
                    context.completeStep();
                }
            }, OperationContext.Stage.RUNTIME);
        } else {
            context.getResult().set(ConnectorMessages.MESSAGES.noMetricsAvailable());
        }
        context.completeStep();
    }
}

