/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service;

import java.util.LinkedHashSet;
import org.hibernate.integrator.internal.IntegratorServiceImpl;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.service.BootstrapServiceRegistry;
import org.hibernate.service.classloading.internal.ClassLoaderServiceImpl;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.internal.BootstrapServiceRegistryImpl;

public class BootstrapServiceRegistryBuilder {
    private final LinkedHashSet<Integrator> providedIntegrators = new LinkedHashSet();
    private ClassLoader applicationClassLoader;
    private ClassLoader resourcesClassLoader;
    private ClassLoader hibernateClassLoader;
    private ClassLoader environmentClassLoader;

    public BootstrapServiceRegistryBuilder with(Integrator integrator) {
        this.providedIntegrators.add(integrator);
        return this;
    }

    public BootstrapServiceRegistryBuilder withApplicationClassLoader(ClassLoader classLoader) {
        this.applicationClassLoader = classLoader;
        return this;
    }

    public BootstrapServiceRegistryBuilder withResourceClassLoader(ClassLoader classLoader) {
        this.resourcesClassLoader = classLoader;
        return this;
    }

    public BootstrapServiceRegistryBuilder withHibernateClassLoader(ClassLoader classLoader) {
        this.hibernateClassLoader = classLoader;
        return this;
    }

    public BootstrapServiceRegistryBuilder withEnvironmentClassLoader(ClassLoader classLoader) {
        this.environmentClassLoader = classLoader;
        return this;
    }

    public BootstrapServiceRegistry build() {
        ClassLoaderServiceImpl classLoaderService = new ClassLoaderServiceImpl(this.applicationClassLoader, this.resourcesClassLoader, this.hibernateClassLoader, this.environmentClassLoader);
        IntegratorServiceImpl integratorService = new IntegratorServiceImpl(this.providedIntegrators, classLoaderService);
        return new BootstrapServiceRegistryImpl((ClassLoaderService)classLoaderService, integratorService);
    }
}

