/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.cdi;

import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.resteasy.core.PropertyInjectorImpl;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.PropertyInjector;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class JaxrsInjectionTarget<T>
implements InjectionTarget<T> {
    private InjectionTarget<T> delegate;
    private Class<T> clazz;
    private PropertyInjector propertyInjector;

    public JaxrsInjectionTarget(InjectionTarget<T> delegate, Class<T> clazz) {
        this.delegate = delegate;
        this.clazz = clazz;
    }

    public void inject(T instance, CreationalContext<T> ctx) {
        this.delegate.inject(instance, ctx);
        if (this.propertyInjector == null) {
            this.propertyInjector = this.getPropertyInjector();
        }
        HttpRequest request = (HttpRequest)ResteasyProviderFactory.getContextData(HttpRequest.class);
        HttpResponse response = (HttpResponse)ResteasyProviderFactory.getContextData(HttpResponse.class);
        if (request != null && response != null) {
            this.propertyInjector.inject(request, response, instance);
        } else {
            this.propertyInjector.inject(instance);
        }
    }

    public void postConstruct(T instance) {
        this.delegate.postConstruct(instance);
    }

    public void preDestroy(T instance) {
        this.delegate.preDestroy(instance);
    }

    public void dispose(T instance) {
        this.delegate.dispose(instance);
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return this.delegate.getInjectionPoints();
    }

    public T produce(CreationalContext<T> ctx) {
        return (T)this.delegate.produce(ctx);
    }

    private PropertyInjector getPropertyInjector() {
        return new PropertyInjectorImpl(this.clazz, ResteasyProviderFactory.getInstance());
    }
}

