/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.naming;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CosNaming.Binding;
import org.omg.CosNaming.BindingHolder;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;

public class ContextLister {
    public NamingContextExt root_context;
    private Hashtable contexts = new Hashtable();
    private ORB orb;

    public ContextLister(ORB oRB) {
        this.orb = oRB;
        try {
            Object object = oRB.resolve_initial_references("NameService");
            this.root_context = NamingContextExtHelper.narrow(object);
        }
        catch (InvalidName invalidName) {
            invalidName.printStackTrace();
        }
        catch (SystemException systemException) {
            System.err.println(systemException);
        }
        if (this.root_context == null) {
            System.err.println("No Naming Context available, giving up ...");
            System.exit(1);
        }
    }

    public ContextLister(ORB oRB, String string) {
        this.orb = oRB;
        try {
            Object object = oRB.string_to_object(string);
            this.root_context = NamingContextExtHelper.narrow(object);
        }
        catch (SystemException systemException) {
            System.err.println(systemException);
        }
        if (this.root_context == null) {
            System.err.println("No Naming Context available, giving up ...");
            System.exit(1);
        }
    }

    private void mark(NamingContextExt namingContextExt) {
        this.contexts.put(this.orb.object_to_string(namingContextExt), "");
    }

    private boolean isMarked(NamingContextExt namingContextExt) {
        return this.contexts.containsKey(this.orb.object_to_string(namingContextExt));
    }

    public void list(PrintStream printStream) {
        this.list(this.root_context, "   ", printStream);
    }

    private void list(NamingContextExt namingContextExt, String string, PrintStream printStream) {
        if (this.isMarked(namingContextExt)) {
            return;
        }
        this.mark(namingContextExt);
        try {
            BindingListHolder bindingListHolder = new BindingListHolder(new Binding[0]);
            BindingIteratorHolder bindingIteratorHolder = new BindingIteratorHolder();
            namingContextExt.list(0, bindingListHolder, bindingIteratorHolder);
            BindingHolder bindingHolder = new BindingHolder();
            if (bindingIteratorHolder.value == null) {
                return;
            }
            while (bindingIteratorHolder.value.next_one(bindingHolder)) {
                String string2 = this.root_context.to_string(bindingHolder.value.binding_name);
                printStream.print(string + string2);
                if (bindingHolder.value.binding_type.value() == 1) {
                    String string3 = string + "\t";
                    printStream.println("/");
                    NameComponent[] nameComponentArray = this.root_context.to_name(string2);
                    NamingContextExt namingContextExt2 = NamingContextExtHelper.narrow(namingContextExt.resolve(nameComponentArray));
                    this.list(namingContextExt2, string3, printStream);
                    continue;
                }
                System.out.println();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        ORB oRB = ORB.init(stringArray, null);
        PrintStream printStream = System.out;
        String string = null;
        for (int i = 0; i < stringArray.length; i += 2) {
            try {
                if (stringArray[i].startsWith("-f")) {
                    try {
                        printStream = new PrintStream(new FileOutputStream(stringArray[i + 1]));
                    }
                    catch (IOException iOException) {
                        System.err.println(iOException.getMessage());
                        System.exit(1);
                    }
                    continue;
                }
                if (!stringArray[i].startsWith("-url")) continue;
                string = stringArray[i + 1];
                continue;
            }
            catch (Exception exception) {
                System.err.println("Usage: org.jacorb.naming.ContextLister [-url object url] [-f output file]");
                System.exit(1);
            }
        }
        ContextLister contextLister = string != null ? new ContextLister(oRB, string) : new ContextLister(oRB);
        contextLister.list(printStream);
        oRB.shutdown(true);
    }
}

