#!/bin/sh
if [ -z "$PYTHON_EXE" ]; then
    PYTHON_EXE="python2"
fi

function terminate_jobs {
    running_jobs=$(jobs -pr)
    if [ -n "$running_jobs" ]; then
        kill $running_jobs
    fi
}

trap terminate_jobs EXIT

export \
    LC_ALL=C \
    NOSE_EVAL_ATTR \
    NOSE_LOGFORMAT='%(asctime)s %(levelname)-5s (%(threadName)s) [%(name)s] %(message)s (%(module)s:%(lineno)d)' \
    NOSE_VERBOSE=${NOSE_VERBOSE:-3} \
    PYTHONDONTWRITEBYTECODE=1 \
    PYTHONPATH="../static/usr/share/vdsm:../lib:../vdsm_api:$PYTHONPATH" \
    $NULL

"$PYTHON_EXE" ../tests/testrunner.py --local-modules $@ &
runner_pid=$!

if [ -n "$TIMEOUT" ]; then
    ./py-watch $runner_pid $TIMEOUT &
fi

wait $runner_pid
