#!/bin/bash
#
# Copyright 2012 Red Hat, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#
# Refer to the README and COPYING files for full details of the license
#

VDSM_CA="$1"
VDSM_KEY="$2"
VDSM_CRT="$3"

VDSM_TEMPLATE="$(mktemp)"

VDSM_FQDN=`hostname -f`
[ -z "$VDSM_FQDN" ] && VDSM_FQDN="localhost.localdomain"

VDSM_PERMS="vdsm:kvm"

umask 077

if [ ! -f "$VDSM_KEY" ]; then
    /usr/bin/certtool --generate-privkey --outfile "$VDSM_KEY" 2> /dev/null
    /bin/chown "$VDSM_PERMS" "$VDSM_KEY"
    /sbin/restorecon "$VDSM_KEY"
fi

if [ ! -f "$VDSM_CA" ]; then
    /bin/cat > "$VDSM_TEMPLATE" <<EOF
cn = "VDSM Certificate Authority"
ca
activation_date = $(date -d "yesterday" +"%Y-%m-%d %H:%M:%S")
cert_signing_key
EOF
    /usr/bin/certtool --generate-self-signed --load-privkey  "$VDSM_KEY" \
                      --template "$VDSM_TEMPLATE" --outfile "$VDSM_CA" \
                      2> /dev/null
    /bin/chown "$VDSM_PERMS" "$VDSM_CA"
    /sbin/restorecon "$VDSM_CA"
fi

if [ ! -f "$VDSM_CRT" ]; then
    /bin/cat > "$VDSM_TEMPLATE" <<EOF
organization    = "VDSM Certificate"
cn              = "$VDSM_FQDN"
email           = "root@$VDSM_FQDN"
activation_date = $(date -d "yesterday" +"%Y-%m-%d %H:%M:%S")
signing_key
encryption_key
tls_www_server
tls_www_client
EOF
    /usr/bin/certtool --generate-certificate --load-privkey "$VDSM_KEY" \
                      --load-ca-privkey "$VDSM_KEY" \
                      --load-ca-certificate "$VDSM_CA" \
                      --template "$VDSM_TEMPLATE" --outfile "$VDSM_CRT" \
                      2> /dev/null
    /bin/chown "$VDSM_PERMS" "$VDSM_CRT"
    /sbin/restorecon "$VDSM_CRT"
fi

/bin/rm -f "$VDSM_TEMPLATE"
